/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.common.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.Lazy;
import net.nokunami.elementus.common.config.ArmorConfig;
import net.nokunami.elementus.common.config.UniqueItemConfig;
import net.nokunami.elementus.common.item.ElementusArmorItem;
import net.nokunami.elementus.common.registry.ModArmorMaterials;
import org.jetbrains.annotations.NotNull;

public class DiarkriteBootsItem
extends ElementusArmorItem {
    private final Lazy<Multimap<Attribute, AttributeModifier>> silencedAttributes = Lazy.of(() -> this.createDefaultAttributeModifiers().build());

    public DiarkriteBootsItem(ModArmorMaterials material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    protected ImmutableMultimap.Builder<Attribute, AttributeModifier> createDefaultAttributeModifiers() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID uuid = (UUID)f_265987_.get(this.f_265916_);
        builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "Armor modifier", (double)this.m_40404_(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(uuid, "Armor toughness", UniqueItemConfig.diarkriteBootsToughness, AttributeModifier.Operation.ADDITION));
        if (UniqueItemConfig.diarkriteBootsKnockbackResistance != 0.0) {
            builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(uuid, "Knockback resistance", UniqueItemConfig.diarkriteBootsKnockbackResistance, AttributeModifier.Operation.ADDITION));
        }
        if (ArmorConfig.diarkriteArmor_AttackSpeed != 0.0) {
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(uuid, "Speed Modifier", ArmorConfig.diarkriteArmor_AttackSpeed, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        if (UniqueItemConfig.diarkriteBootsMovementSpeed != 0.0) {
            builder.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(uuid, "Speed Modifier", UniqueItemConfig.diarkriteBootsMovementSpeed, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        if (UniqueItemConfig.diarkriteBootsStepHeight != 0.0) {
            builder.put((Object)((Attribute)ForgeMod.STEP_HEIGHT.get()), (Object)new AttributeModifier(uuid, "Step Height Modifier", UniqueItemConfig.diarkriteBootsStepHeight, AttributeModifier.Operation.ADDITION));
        }
        return builder;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == this.f_265916_.m_266308_()) {
            if (DiarkriteBootsItem.getSculkSilencer(stack)) {
                return (Multimap)this.silencedAttributes.get();
            }
            return (Multimap)this.defaultModifiers.get();
        }
        return ImmutableMultimap.of();
    }

    public boolean m_142305_(@NotNull ItemStack stack, @NotNull ItemStack otherStack, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player, @NotNull SlotAccess access) {
        if (otherStack.m_41619_() && action == ClickAction.SECONDARY) {
            DiarkriteBootsItem.setSculkSilencer(stack, !DiarkriteBootsItem.getSculkSilencer(stack));
            player.m_216990_(SoundEvents.f_11897_);
            return true;
        }
        return super.m_142305_(stack, otherStack, slot, action, player, access);
    }

    public static boolean getSculkSilencer(ItemStack stack) {
        return stack.m_41784_().m_128471_("SculkSilencer");
    }

    public static void setSculkSilencer(ItemStack stack, boolean b) {
        stack.m_41784_().m_128379_("SculkSilencer", b);
    }

    public static boolean SculkWalkerActivation(LivingEntity entity) {
        ItemStack itemStack = entity.m_6844_(EquipmentSlot.FEET);
        return itemStack.m_41720_() instanceof DiarkriteBootsItem && DiarkriteBootsItem.getSculkSilencer(itemStack);
    }
}

