/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.common.item;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.nokunami.elementus.common.config.UniqueItemConfig;
import net.nokunami.elementus.common.entity.MobUtil;
import net.nokunami.elementus.common.entity.projectile.PulseBurstEntity;
import net.nokunami.elementus.common.item.ChargeBladeItem;
import net.nokunami.elementus.common.registry.ModEnchantments;
import net.nokunami.elementus.common.registry.ModParticleTypes;
import net.nokunami.elementus.common.registry.ModSoundEvents;
import net.nokunami.elementus.common.registry.ModTiers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiarkriteChargeBlade
extends ChargeBladeItem {
    private static final int BURST_RANGE = 3;
    private static final int BOOM_RANGE = 20;
    private static final int RUSH_RANGE = 8;

    public DiarkriteChargeBlade() {
        super(ModTiers.DIARKRITE, UniqueItemConfig.diarkriteChargeBladeDamage, (float)UniqueItemConfig.diarkriteChargeBladeAttackSpeed, (float)UniqueItemConfig.diarkriteChargeBladeAttackReach, new Item.Properties().m_41486_().m_41497_(Rarity.EPIC));
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        boolean i = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)ModEnchantments.SACRIFICE_CURSE.get()), (ItemStack)stack) > 0;
        Map Ench = EnchantmentHelper.m_44831_((ItemStack)stack);
        if (Ench.size() == 1 && Ench.containsKey(ModEnchantments.SACRIFICE_CURSE.get())) {
            return false;
        }
        return super.m_5812_(stack) || !i && stack.m_41793_();
    }

    @Override
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        Minecraft mc = Minecraft.m_91087_();
        assert (mc.f_91074_ != null);
        boolean creative = mc.f_91074_.m_7500_();
        String damageModifierText = DiarkriteChargeBlade.isEnchantedWith(stack, ModEnchantments.SACRIFICE_CURSE) ? " (+125%)" : "";
        ChatFormatting damageModifierColor = DiarkriteChargeBlade.isEnchantedWith(stack, ModEnchantments.SACRIFICE_CURSE) || DiarkriteChargeBlade.isEnchantedWith(stack, ModEnchantments.CONDENSED_BURST) ? ChatFormatting.GOLD : ChatFormatting.DARK_AQUA;
        double damage = (double)DiarkriteChargeBlade.getChargeAmount(stack, false) * UniqueItemConfig.diarkriteChargeBladeSonicDamage;
        double damageR = (double)DiarkriteChargeBlade.getChargeAmount(stack, creative) * UniqueItemConfig.diarkriteChargeBladeSonicDamage;
        double damageNumber = (double)Math.round(damage * 10.0) / 10.0;
        double damageNumberR = (double)Math.round(damageR * 10.0) / 10.0;
        MutableComponent damageText = Component.m_237115_((String)String.valueOf(damageNumber)).m_130940_(ChatFormatting.DARK_AQUA).m_130946_((String)(creative ? " (" + damageNumberR + ")" : ""));
        super.m_7373_(stack, level, tooltip, flag);
        if (DiarkriteChargeBlade.getResonanceCharge(stack) > 0) {
            tooltip.add((Component)Component.m_237110_((String)(this.m_5524_() + ".resonance_charge_desc"), (Object[])new Object[]{DiarkriteChargeBlade.getResonanceCharge(stack)}).m_130940_(ChatFormatting.DARK_GRAY));
        }
        tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".damage_desc")).m_130940_(ChatFormatting.GRAY).m_7220_((Component)damageText).m_7220_((Component)Component.m_237115_((String)damageModifierText).m_130940_(damageModifierColor)));
        if (Screen.m_96638_()) {
            if (DiarkriteChargeBlade.isEnchantedWith(stack, ModEnchantments.SACRIFICE_CURSE)) {
                if (!(UniqueItemConfig.diarkriteChargeBladeSacrificeDamageBonus <= 0.0)) {
                    tooltip.add((Component)Component.m_237113_((String)"|").m_130940_(ChatFormatting.GRAY).m_7220_((Component)CommonComponents.m_264333_().m_7220_((Component)Component.m_237110_((String)(this.m_5524_() + ".damage_bonus_sacrifice"), (Object[])new Object[]{Math.round((UniqueItemConfig.diarkriteChargeBladeSacrificeDamageBonus + 1.0) * 100.0)}).m_7220_((Component)Component.m_237115_((String)"enchantment.elementus.sacrifice_curse")).m_130940_(ChatFormatting.YELLOW))));
                }
                if (!(UniqueItemConfig.diarkriteChargeBladeSelfSacrificeDamage <= 0.0)) {
                    tooltip.add((Component)Component.m_237113_((String)"|").m_130940_(ChatFormatting.GRAY).m_7220_((Component)CommonComponents.m_264333_().m_7220_((Component)Component.m_237110_((String)(this.m_5524_() + ".self_sacrifice_damage"), (Object[])new Object[]{Math.round(UniqueItemConfig.diarkriteChargeBladeSelfSacrificeDamage * 100.0)}).m_7220_((Component)Component.m_237115_((String)"enchantment.elementus.sacrifice_curse")).m_130940_(ChatFormatting.RED))));
                }
            }
            if (DiarkriteChargeBlade.isEnchantedWith(stack, ModEnchantments.CONDENSED_BURST)) {
                tooltip.add((Component)Component.m_237113_((String)"|").m_130940_(ChatFormatting.GRAY).m_7220_((Component)CommonComponents.m_264333_().m_7220_((Component)Component.m_237110_((String)(this.m_5524_() + ".charge_penalty_condensed_burst"), (Object[])new Object[]{Math.round(((float)UniqueItemConfig.diarkriteChargeBladeChargePenalty / (float)UniqueItemConfig.diarkriteChargeBladeBaseCharge - 1.0f) * 100.0f)}).m_7220_((Component)Component.m_237115_((String)"enchantment.elementus.condensed_burst")).m_130940_(ChatFormatting.RED))));
            }
            if (DiarkriteChargeBlade.isEnchantedWith(stack, ModEnchantments.CHARGE_STACKING)) {
                tooltip.add((Component)Component.m_237113_((String)"|").m_130940_(ChatFormatting.GRAY).m_7220_((Component)CommonComponents.m_264333_().m_7220_((Component)Component.m_237110_((String)(this.m_5524_() + ".multi_charge"), (Object[])new Object[]{Math.round((float)(DiarkriteChargeBlade.getMaxCharge(stack) / DiarkriteChargeBlade.getChargeStack(stack)) - 1.0f) * 100}).m_7220_((Component)Component.m_237115_((String)"enchantment.elementus.multi_charge")).m_130940_(ChatFormatting.GREEN))));
            }
        }
        this.friendlyFireTooltip(tooltip, stack);
        if (stack.m_41793_()) {
            tooltip.add(CommonComponents.f_237098_);
        }
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return DiarkriteChargeBlade.isEnchantedWith(stack, ModEnchantments.SACRIFICE_CURSE) ? 0xFF5555 : 7924965;
    }

    @Override
    public boolean canParry() {
        return true;
    }

    public static float boomRadius(ItemStack stack) {
        return DiarkriteChargeBlade.isEnchantedWith(stack, ModEnchantments.RUSH) || DiarkriteChargeBlade.isEnchantedWith(stack, ModEnchantments.CONDENSED_BURST) ? 1.25f : 2.5f;
    }

    public static float boomRange(ItemStack stack) {
        return DiarkriteChargeBlade.isEnchantedWith(stack, ModEnchantments.CONDENSED_BURST) ? 20.0f : (DiarkriteChargeBlade.isEnchantedWith(stack, ModEnchantments.RUSH) ? 8.0f : 3.0f);
    }

    public static void createBoom(Level level, LivingEntity livingEntity, ItemStack stack) {
        SoundEvent condensedSound;
        float chargeAmount = DiarkriteChargeBlade.getChargeAmount(stack, ((Player)livingEntity).m_7500_());
        boolean isCursed = DiarkriteChargeBlade.isEnchantedWith(stack, ModEnchantments.SACRIFICE_CURSE);
        boolean isCondensed = DiarkriteChargeBlade.isEnchantedWith(stack, ModEnchantments.CONDENSED_BURST);
        SimpleParticleType particleTypes = isCursed && !isCondensed ? (SimpleParticleType)ModParticleTypes.SACRIFICE_SONIC_BURST_EMITTER.get() : (isCursed ? (SimpleParticleType)ModParticleTypes.SACRIFICE_SONIC_BOOM.get() : (isCondensed ? ParticleTypes.f_235902_ : (SimpleParticleType)ModParticleTypes.SONIC_BURST_EMITTER.get()));
        SimpleParticleType startParticle = isCursed ? (SimpleParticleType)ModParticleTypes.SACRIFICE_SONIC_BOOM_START.get() : (SimpleParticleType)ModParticleTypes.SONIC_BOOM_START.get();
        Vec3 target = livingEntity.m_146892_().m_82549_(Vec3.m_82498_((float)livingEntity.m_146909_(), (float)livingEntity.f_20885_).m_82490_((double)DiarkriteChargeBlade.boomRange(stack)));
        Vec3 source = livingEntity.m_146892_();
        Vec3 offsetToTarget = target.m_82546_(source);
        Vec3 normalized = offsetToTarget.m_82541_();
        boolean firstTick = true;
        HashSet hitSet = new HashSet();
        for (int particleIndex = 2; particleIndex < Mth.m_14107_((double)offsetToTarget.m_82553_()) + 2; ++particleIndex) {
            Vec3 particle = source.m_82549_(normalized.m_82490_((double)particleIndex));
            if (firstTick) {
                ((ServerLevel)level).m_8767_((ParticleOptions)startParticle, particle.f_82479_, particle.f_82480_, particle.f_82481_, 0, 0.0, 0.0, 0.0, 0.0);
                firstTick = false;
            }
            if (particleIndex > 2) {
                ((ServerLevel)level).m_8767_((ParticleOptions)particleTypes, particle.f_82479_, particle.f_82480_, particle.f_82481_, 0, 0.0, 0.0, 0.0, 0.0);
            }
            hitSet.addAll(level.m_6443_(LivingEntity.class, new AABB(new BlockPos((int)particle.m_7096_(), (int)particle.m_7098_(), (int)particle.m_7094_())).m_82400_((double)DiarkriteChargeBlade.boomRadius(stack)), e -> MobUtil.allied((Entity)livingEntity, (Entity)e, DiarkriteChargeBlade.getFriendlyFire(stack))));
        }
        hitSet.remove(livingEntity);
        if (!livingEntity.m_20096_() || DiarkriteChargeBlade.isEnchantedWith(stack, ModEnchantments.RUSH)) {
            DiarkriteChargeBlade.applyRecoil((Entity)livingEntity, (Entity)livingEntity, chargeAmount * (float)(DiarkriteChargeBlade.isEnchantedWith(stack, ModEnchantments.RUSH) ? 2 : 1), DiarkriteChargeBlade.isEnchantedWith(stack, ModEnchantments.RUSH));
        }
        for (Entity hitTarget : hitSet) {
            if (!(hitTarget instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)hitTarget;
            living.m_6469_(livingEntity.m_269291_().m_269285_((Entity)livingEntity), (float)UniqueItemConfig.diarkriteChargeBladeSonicDamage * chargeAmount);
            DiarkriteChargeBlade.applyRecoil((Entity)living, (Entity)livingEntity, chargeAmount, true);
        }
        if (DiarkriteChargeBlade.isEnchantedWith(stack, ModEnchantments.PULSE_BURST) && !level.f_46443_) {
            PulseBurstEntity slash = new PulseBurstEntity(level, livingEntity);
            slash.setDamage(5.0f);
            slash.setDiscardDistance(24.0f);
            slash.launchSlash((Entity)livingEntity, livingEntity.m_146909_(), livingEntity.m_146908_(), 0.0f, 0.45f, 1.0f);
            level.m_7967_((Entity)slash);
        }
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            serverPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
        }
        DiarkriteChargeBlade.setCharge(stack, -Math.min(DiarkriteChargeBlade.getCharge(stack), DiarkriteChargeBlade.getChargeStack(stack)));
        SoundEvent burstSound = isCursed ? (SoundEvent)ModSoundEvents.DIARKRITE_CHARGE_BLADE_BURST_CURSED.get() : (SoundEvent)ModSoundEvents.DIARKRITE_CHARGE_BLADE_BURST.get();
        SoundEvent soundEvent = condensedSound = isCursed ? (SoundEvent)ModSoundEvents.DIARKRITE_CHARGE_BLADE_CONDENSED_BURST_CURSED.get() : (SoundEvent)ModSoundEvents.DIARKRITE_CHARGE_BLADE_CONDENSED_BURST.get();
        if (DiarkriteChargeBlade.isEnchantedWith(stack, ModEnchantments.CONDENSED_BURST)) {
            level.m_6269_(null, (Entity)livingEntity, condensedSound, SoundSource.PLAYERS, 5.0f, 1.0f);
        } else {
            level.m_6269_(null, (Entity)livingEntity, burstSound, SoundSource.PLAYERS, 2.5f, 1.0f);
        }
    }

    public static void parryParticle(Level level, LivingEntity livingEntity, ParticleOptions particleOptions) {
        Vec3 eyePos = livingEntity.m_146892_();
        Vec3 target = eyePos.m_82549_(Vec3.m_82498_((float)livingEntity.m_146909_(), (float)livingEntity.f_20885_).m_82490_(1.0));
        Vec3 offsetToTarget = target.m_82546_(eyePos);
        Vec3 pos = eyePos.m_82549_(offsetToTarget.m_82541_().m_82490_(1.0));
        ((ServerLevel)level).m_8767_(particleOptions, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0, 0.0, 0.0, 0.0, 0.0);
    }

    public static void parryParticleAlt(Level level, LivingEntity livingEntity, ParticleOptions particleOptions) {
        Vec3 eyePos = livingEntity.m_146892_();
        Vec3 target = eyePos.m_82549_(Vec3.m_82498_((float)livingEntity.m_146909_(), (float)livingEntity.f_20885_).m_82490_(1.0));
        Vec3 offsetToTarget = target.m_82546_(eyePos);
        Vec3 pos = eyePos.m_82549_(offsetToTarget.m_82541_().m_82490_(1.0));
        level.m_7106_(particleOptions, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
    }

    public static void parry(Level level, Player imTheOneWhoParries, LivingEntity waltuhPutTheSwordDownWaltuh, float damageAmount) {
        waltuhPutTheSwordDownWaltuh.m_6469_(level.m_269111_().m_269075_(imTheOneWhoParries), damageAmount);
        waltuhPutTheSwordDownWaltuh.m_6598_(imTheOneWhoParries);
    }
}

