/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.common.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.block.state.BlockState;
import net.nokunami.elementus.common.Etags;
import net.nokunami.elementus.common.config.TierConfig;
import net.nokunami.elementus.common.registry.ModTiers;

public class EItemUtil {
    public static void tooltip(ItemStack stack, List<Component> tooltip, Tier tier) {
        if (EItemUtil.diarkriteTier(tier) && stack.m_41720_() instanceof PickaxeItem) {
            tooltip.add((Component)Component.m_237115_((String)"item.elementus.diarkrite_pickaxe.desc").m_130940_(ChatFormatting.DARK_AQUA));
        }
        if (tier.equals((Object)ModTiers.MOVCADIA)) {
            tooltip.add((Component)Component.m_237115_((String)"item.elementus.movcadia_tool.desc").m_130940_(ChatFormatting.DARK_PURPLE));
        }
    }

    public static float toolMiningSpeed(float originalSpeed, ItemStack stack, BlockState state) {
        float newSpeed = originalSpeed;
        Item var5 = stack.m_41720_();
        if (var5 instanceof DiggerItem) {
            DiggerItem diggerItem = (DiggerItem)var5;
            Tier tier = diggerItem.m_43314_();
            if (diggerItem.isCorrectToolForDrops(stack, state)) {
                if (EItemUtil.matchBlockState(state) && EItemUtil.diarkriteTier(tier) && stack.m_41720_() instanceof PickaxeItem) {
                    newSpeed *= (float)TierConfig.diarkriteAdditionalEfficiency;
                }
                if (tier.equals((Object)ModTiers.MOVCADIA)) {
                    newSpeed *= (float)(1.0 - (double)stack.m_41773_() / (double)stack.m_41776_());
                    if (EItemUtil.getMovcadiaEssence(stack) > 0) {
                        newSpeed *= 2.0f;
                    }
                }
            }
        }
        return newSpeed;
    }

    public static boolean matchBlockState(BlockState state) {
        return state.m_204336_(Etags.Blocks.DIARKRITE_EFFICIENT);
    }

    public static float getDurablityBasedSpeed(ItemStack stack, boolean reverse) {
        if (reverse) {
            return (float)(-2.0 * (double)stack.m_41773_() / (double)stack.m_41776_() + 0.5);
        }
        return (float)(2.0 * (double)stack.m_41773_() / (double)stack.m_41776_() + 0.5);
    }

    public static boolean diarkriteTier(Tier tier) {
        return tier.equals((Object)ModTiers.DIARKRITE) || tier.equals((Object)ModTiers.DIARKRITE_IRON) || tier.equals((Object)ModTiers.DIARKRITE_GOLD) || tier.equals((Object)ModTiers.DIARKRITE_EMERALD) || tier.equals((Object)ModTiers.DIARKRITE_DIAMOND) || tier.equals((Object)ModTiers.DIARKRITE_CMD);
    }

    public static boolean anthektiteTier(Tier tier) {
        return tier.equals((Object)ModTiers.ANTHEKTITE) || tier.equals((Object)ModTiers.ANTHEKTITE_IRON) || tier.equals((Object)ModTiers.ANTHEKTITE_GOLD) || tier.equals((Object)ModTiers.ANTHEKTITE_EMERALD) || tier.equals((Object)ModTiers.ANTHEKTITE_DIAMOND) || tier.equals((Object)ModTiers.ANTHEKTITE_CMD);
    }

    public static boolean cmdTier(Tier tier) {
        return tier.equals((Object)ModTiers.STEEL_CMD) || tier.equals((Object)ModTiers.DIARKRITE_CMD) || tier.equals((Object)ModTiers.ANTHEKTITE_CMD);
    }

    public static boolean getFriendlyFire(ItemStack stack) {
        return stack.m_41784_().m_128471_("FriendlyFire");
    }

    public static void setFriendlyFire(ItemStack stack, boolean b) {
        stack.m_41784_().m_128379_("FriendlyFire", b);
    }

    public static int getMovcadiaEssence(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128451_("MovcadiaEssence") : 0;
    }

    public static void setMovcadiaEssence(ItemStack stack) {
        EItemUtil.setMovcadiaEssence(stack, 32);
    }

    public static void setMovcadiaEssence(ItemStack stack, int b) {
        stack.m_41784_().m_128405_("MovcadiaEssence", b);
    }

    public static int getEssenceBarWidth(ItemStack stack) {
        return Math.round(13.0f - (float)(32 - EItemUtil.getMovcadiaEssence(stack)) * 13.0f / 32.0f);
    }

    public boolean canBeHurtBy(DamageSource source, Tier tier) {
        return !tier.equals((Object)ModTiers.STEEL_CMD) && !tier.equals((Object)ModTiers.DIARKRITE_CMD) && !tier.equals((Object)ModTiers.ANTHEKTITE_CMD);
    }

    public static void movcadiaClickAction(ItemStack stack, ItemStack otherStack, Player player) {
        player.m_216990_(SoundEvents.f_11897_);
        otherStack.m_41774_(1);
        EItemUtil.setMovcadiaEssence(stack);
    }
}

