/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.common.item;

import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.nokunami.elementus.Elementus;
import net.nokunami.elementus.ModChecker;
import net.nokunami.elementus.common.compat.sniffsweapons.SWModItems;
import net.nokunami.elementus.common.item.CatalystArmorItem;
import net.nokunami.elementus.common.item.DiarkriteChargeBlade;
import net.nokunami.elementus.common.item.EItemUtil;
import net.nokunami.elementus.common.registry.ModEnchantments;
import net.nokunami.elementus.common.registry.ModItems;

public class ItemPredicateRegister {
    public static void registerItemPredicate() {
        ItemPredicateRegister.shieldBlocking((Item)ModItems.ElementusItems.STEEL_SHIELD.get());
        ItemPredicateRegister.shieldBlocking((Item)ModItems.ElementusItems.ANTHEKTITE_SHIELD.get());
        ItemPredicateRegister.shieldBlocking((Item)ModItems.ElementusItems.DIARKRITE_SHIELD.get());
        if (ModChecker.sniffsWeapons) {
            ItemPredicateRegister.shieldBlocking((Item)SWModItems.STEEL_GREAT_PICKAXE.get());
            ItemPredicateRegister.shieldBlocking((Item)SWModItems.DIARKRITE_GREAT_PICKAXE.get());
            ItemPredicateRegister.shieldBlocking((Item)SWModItems.ANTHEKTITE_GREAT_PICKAXE.get());
        }
        ItemPredicateRegister.catalystArmor((Item)ModItems.ElementusItems.CATALYST_CHESTPLATE.get());
        if (ModChecker.archeryExp) {
            ItemPredicateRegister.aeComapt((Item)ModItems.ElementusItems.STEEL_BOW.get());
            ItemPredicateRegister.aeComapt((Item)ModItems.ElementusItems.DIARKRITE_BOW.get());
            ItemPredicateRegister.aeComapt((Item)ModItems.ElementusItems.ANTHEKTITE_BOW.get());
        } else {
            ItemPredicateRegister.bowPull((Item)ModItems.ElementusItems.STEEL_BOW.get());
            ItemPredicateRegister.bowPull((Item)ModItems.ElementusItems.DIARKRITE_BOW.get());
            ItemPredicateRegister.bowPull((Item)ModItems.ElementusItems.ANTHEKTITE_BOW.get());
        }
        ItemPredicateRegister.chargeBlade((Item)ModItems.ElementusItems.DIARKRITE_CHARGE_BLADE.get());
        ItemPredicateRegister.chargeBlade((Item)ModItems.ElementusItems.ANTHEKTITE_CHARGE_BLADE.get());
        ItemPredicateRegister.movcadiaTools((Item)ModItems.ElementusItems.MOVCADIA_SWORD.get());
        ItemPredicateRegister.movcadiaTools((Item)ModItems.ElementusItems.MOVCADIA_SHOVEL.get());
        ItemPredicateRegister.movcadiaTools((Item)ModItems.ElementusItems.MOVCADIA_PICKAXE.get());
        ItemPredicateRegister.movcadiaTools((Item)ModItems.ElementusItems.MOVCADIA_AXE.get());
        ItemPredicateRegister.movcadiaTools((Item)ModItems.ElementusItems.MOVCADIA_HOE.get());
    }

    private static void shieldBlocking(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("blocking"), (itemStack, clientLevel, livingEntity, i) -> livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == itemStack ? 1.0f : 0.0f);
    }

    private static void catalystArmor(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("elementus", "catalyst"), (itemStack, clientLevel, livingEntity, i) -> switch (CatalystArmorItem.catalystActivator(itemStack)) {
            case "nether_star" -> 0.11f;
            case "ignitium_ingot" -> 0.12f;
            case "arcane_ingot" -> 0.13f;
            case "heart_of_the_sea" -> 0.14f;
            case "totem_of_undying" -> 0.15f;
            case "cursium_ingot" -> 0.16f;
            case "withered_nether_star" -> 0.17f;
            default -> 0.0f;
        });
    }

    private static void bowPull(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("pulling"), (itemStack, clientLevel, livingEntity, i) -> livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == itemStack ? 1.0f : 0.0f);
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("pull"), (itemStack, clientLevel, livingEntity, i) -> livingEntity != null ? (livingEntity.m_21211_() != itemStack ? 0.0f : (float)(itemStack.m_41779_() - livingEntity.m_21212_()) / 20.0f) : 0.0f);
    }

    private static void aeComapt(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("drawing"), (itemStack, clientLevel, livingEntity, i) -> livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == itemStack ? 1.0f : 0.0f);
    }

    private static void chargeBlade(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("blocking"), (itemStack, clientLevel, livingEntity, i) -> livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == itemStack ? 1.0f : 0.0f);
        ItemProperties.register((Item)item, (ResourceLocation)Elementus.modLoc("sacrifice"), (itemStack, clientLevel, livingEntity, i) -> DiarkriteChargeBlade.isEnchantedWith(itemStack, ModEnchantments.SACRIFICE_CURSE) ? 1.0f : 0.0f);
        ItemProperties.register((Item)item, (ResourceLocation)Elementus.modLoc("charge_stacking"), (itemStack, clientLevel, livingEntity, i) -> DiarkriteChargeBlade.isEnchantedWith(itemStack, ModEnchantments.CHARGE_STACKING) ? 1.0f : 0.0f);
        ItemProperties.register((Item)item, (ResourceLocation)Elementus.modLoc("charge_stacking"), (itemStack, clientLevel, livingEntity, i) -> DiarkriteChargeBlade.isEnchantedWith(itemStack, ModEnchantments.RUSH) ? 1.0f : 0.0f);
        ItemProperties.register((Item)item, (ResourceLocation)Elementus.modLoc("charge"), (itemStack, clientLevel, livingEntity, i) -> {
            float i0 = Math.min(DiarkriteChargeBlade.getCharge(itemStack), DiarkriteChargeBlade.getMaxCharge(itemStack));
            float i1 = DiarkriteChargeBlade.getMaxCharge(itemStack);
            return i0 / i1;
        });
    }

    private static void movcadiaTools(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)Elementus.modLoc("damage_state"), (itemStack, clientLevel, livingEntity, i) -> (float)itemStack.m_41776_() / (float)itemStack.m_41776_());
        ItemProperties.register((Item)item, (ResourceLocation)Elementus.modLoc("empowered"), (itemStack, clientLevel, livingEntity, i) -> EItemUtil.getMovcadiaEssence(itemStack) > 0 ? 1.0f : 0.0f);
    }
}

