/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.common.item;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.nokunami.elementus.Elementus;
import net.nokunami.elementus.common.entity.living.SteelGolem;
import net.nokunami.elementus.common.item.GolemUpgradeProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SteelGolemUpgradeItem
extends Item {
    public final GolemUpgradeProperties properties;
    private static final String TEX_FOLDER = "textures/entity/golem/steel_golem/";
    private final ResourceLocation texture;
    public String identifier;

    public void onArmorTick(ItemStack stack, Level level, SteelGolem entity) {
        if (!entity.isChassisBroken()) {
            for (Pair<MobEffectInstance, Float> pair : this.properties.getEffects()) {
                if (level.f_46443_ || pair.getFirst() == null || !(level.f_46441_.m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
                entity.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
            }
        }
    }

    public SteelGolemUpgradeItem(String identifier, Item.Properties properties, GolemUpgradeProperties golemUpgradeProperties) {
        super(properties);
        this.texture = Elementus.modLoc("textures/entity/golem/steel_golem/armor/golem_armor_" + identifier + ".png");
        this.identifier = identifier;
        this.properties = golemUpgradeProperties;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public boolean isNotPushable() {
        return this.properties != null && this.properties.isNotPushable();
    }

    public boolean isFastAttack() {
        return this.properties != null && this.properties.isFastAttack();
    }

    public GolemUpgradeProperties getGolemUpgradeProperties() {
        return this.properties;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag flag) {
        super.m_7373_(stack, level, components, flag);
        String armorId = "item.elementus.golem_upgrade." + this.identifier;
        components.add((Component)Component.m_237115_((String)armorId).m_130940_(ChatFormatting.GRAY));
        components.add((Component)Component.m_237115_((String)"item.elementus.golem_upgrade.upgrades").m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.GOLD));
        this.bonusDescription(components, "item.elementus.golem_upgrade.pushable", this.properties.isNotPushable());
        this.bonusDescription(components, "item.elementus.golem_upgrade.fast_attack", this.properties.isFastAttack());
        components.add((Component)CommonComponents.m_264333_());
        components.add((Component)Component.m_237115_((String)"item.elementus.golem_upgrade.modifier_equip").m_130940_(ChatFormatting.GRAY));
        this.statDescription(components, "attribute.name.generic.armor", this.properties.getArmor());
        this.statDescription(components, "attribute.name.generic.armor_toughness", this.properties.getToughness());
    }

    public void statDescription(List<Component> components, String translationKey, double value) {
        ChatFormatting formatting;
        String adjective = value > 0.0 ? "attribute.modifier.plus.0" : "attribute.modifier.take.0";
        ChatFormatting chatFormatting = formatting = value > 0.0 ? ChatFormatting.BLUE : ChatFormatting.RED;
        if (value != 0.0) {
            components.add((Component)Component.m_237110_((String)adjective, (Object[])new Object[]{Math.round(value / 10.0 * 10.0), Component.m_237115_((String)translationKey)}).m_130940_(formatting));
        }
    }

    public void bonusDescription(List<Component> components, String translationKey, boolean value) {
        if (value) {
            components.add((Component)CommonComponents.m_264333_().m_7220_((Component)Component.m_237115_((String)translationKey)).m_130940_(ChatFormatting.YELLOW));
        }
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    @NotNull
    public String m_5524_() {
        return "item.elementus.golem_upgrade";
    }
}

