/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.common.item;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class WorldCompassItem
extends Item
implements Vanishable {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String TAG_LODESTONE_POS = "LodestonePos";
    public static final String TAG_LODESTONE_DIMENSION = "LodestoneDimension";
    public static final String TAG_LODESTONE_TRACKED = "LodestoneTracked";

    public WorldCompassItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public static boolean isLodestoneCompass(ItemStack pStack) {
        CompoundTag compoundtag = pStack.m_41783_();
        return compoundtag != null && (compoundtag.m_128441_(TAG_LODESTONE_DIMENSION) || compoundtag.m_128441_(TAG_LODESTONE_POS));
    }

    private static Optional<ResourceKey<Level>> getLodestoneDimension(CompoundTag pCompoundTag) {
        return Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)pCompoundTag.m_128423_(TAG_LODESTONE_DIMENSION)).result();
    }

    @Nullable
    public static GlobalPos getLodestonePosition(CompoundTag pTag) {
        Optional<ResourceKey<Level>> optional;
        boolean flag = pTag.m_128441_(TAG_LODESTONE_POS);
        boolean flag1 = pTag.m_128441_(TAG_LODESTONE_DIMENSION);
        if (flag && flag1 && (optional = WorldCompassItem.getLodestoneDimension(pTag)).isPresent()) {
            BlockPos blockpos = NbtUtils.m_129239_((CompoundTag)pTag.m_128469_(TAG_LODESTONE_POS));
            return GlobalPos.m_122643_(optional.get(), (BlockPos)blockpos);
        }
        return null;
    }

    @Nullable
    public static GlobalPos getSpawnPosition(Level pLevel) {
        return pLevel.m_6042_().f_63858_() ? GlobalPos.m_122643_((ResourceKey)pLevel.m_46472_(), (BlockPos)pLevel.m_220360_()) : null;
    }

    public boolean m_5812_(@NotNull ItemStack pStack) {
        return WorldCompassItem.isLodestoneCompass(pStack) || super.m_5812_(pStack);
    }

    public void m_6883_(@NotNull ItemStack pStack, Level pLevel, @NotNull Entity pEntity, int pItemSlot, boolean pIsSelected) {
        if (!pLevel.f_46443_ && WorldCompassItem.isLodestoneCompass(pStack)) {
            BlockPos blockpos;
            CompoundTag compoundtag = pStack.m_41784_();
            if (compoundtag.m_128441_(TAG_LODESTONE_TRACKED) && !compoundtag.m_128471_(TAG_LODESTONE_TRACKED)) {
                return;
            }
            Optional<ResourceKey<Level>> optional = WorldCompassItem.getLodestoneDimension(compoundtag);
            if (optional.isPresent() && optional.get() == pLevel.m_46472_() && compoundtag.m_128441_(TAG_LODESTONE_POS) && (!pLevel.m_46739_(blockpos = NbtUtils.m_129239_((CompoundTag)compoundtag.m_128469_(TAG_LODESTONE_POS))) || !((ServerLevel)pLevel).m_8904_().m_217874_(PoiTypes.f_218065_, blockpos))) {
                compoundtag.m_128473_(TAG_LODESTONE_POS);
            }
        }
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext pContext) {
        boolean flag;
        BlockPos blockpos = pContext.m_8083_();
        Level level = pContext.m_43725_();
        if (!level.m_8055_(blockpos).m_60713_(Blocks.f_50729_)) {
            return super.m_6225_(pContext);
        }
        level.m_5594_(null, blockpos, SoundEvents.f_12107_, SoundSource.PLAYERS, 1.0f, 1.0f);
        Player player = pContext.m_43723_();
        ItemStack itemstack = pContext.m_43722_();
        boolean bl = flag = !player.m_150110_().f_35937_ && itemstack.m_41613_() == 1;
        if (flag) {
            this.addLodestoneTags((ResourceKey<Level>)level.m_46472_(), blockpos, itemstack.m_41784_());
        } else {
            ItemStack itemstack1 = new ItemStack((ItemLike)Items.f_42522_, 1);
            CompoundTag compoundtag = itemstack.m_41782_() ? itemstack.m_41783_().m_6426_() : new CompoundTag();
            itemstack1.m_41751_(compoundtag);
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.addLodestoneTags((ResourceKey<Level>)level.m_46472_(), blockpos, compoundtag);
            if (!player.m_150109_().m_36054_(itemstack1)) {
                player.m_36176_(itemstack1, false);
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private void addLodestoneTags(ResourceKey<Level> pLodestoneDimension, BlockPos pLodestonePos, CompoundTag pCompoundTag) {
        pCompoundTag.m_128365_(TAG_LODESTONE_POS, (Tag)NbtUtils.m_129224_((BlockPos)pLodestonePos));
        Level.f_46427_.encodeStart((DynamicOps)NbtOps.f_128958_, pLodestoneDimension).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_40731_ -> pCompoundTag.m_128365_(TAG_LODESTONE_DIMENSION, p_40731_));
        pCompoundTag.m_128379_(TAG_LODESTONE_TRACKED, true);
    }

    @NotNull
    public String m_5671_(@NotNull ItemStack pStack) {
        return WorldCompassItem.isLodestoneCompass(pStack) ? "item.elementus.lodestone_compass" : super.m_5671_(pStack);
    }
}

