/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.common.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.nokunami.elementus.common.config.UniqueItemConfig;
import net.nokunami.elementus.common.item.AnthektiteChargeBlade;
import net.nokunami.elementus.common.item.ChargeBladeItem;
import net.nokunami.elementus.common.item.DiarkriteChargeBlade;
import net.nokunami.elementus.common.registry.ModDamageTypes;
import net.nokunami.elementus.common.registry.ModEnchantments;
import net.nokunami.elementus.common.registry.ModMobEffects;

public class ChargeBladeAbilityPacket {
    protected InteractionHand hand;

    public ChargeBladeAbilityPacket(InteractionHand handIn) {
        this.hand = handIn;
    }

    public static void encode(ChargeBladeAbilityPacket packet, FriendlyByteBuf buf) {
        buf.m_130068_((Enum)packet.hand);
    }

    public static ChargeBladeAbilityPacket decode(FriendlyByteBuf buf) {
        return new ChargeBladeAbilityPacket((InteractionHand)buf.m_130066_(InteractionHand.class));
    }

    public static void consume(ChargeBladeAbilityPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            assert (player != null);
            Item item = player.m_21120_(packet.hand).m_41720_();
            ItemStack itemStack = player.m_21120_(packet.hand);
            if (item instanceof ChargeBladeItem && !itemStack.m_41619_() && player.m_6117_() && !player.m_36335_().m_41519_(itemStack.m_41720_())) {
                ChargeBladeAbilityPacket.ability((Player)player, packet.hand);
            }
        });
    }

    public static void ability(Player player, InteractionHand hand) {
        Level level = player.m_9236_();
        ItemStack stack = player.m_21211_();
        if (!level.f_46443_ && !player.m_5833_() && player.m_6117_()) {
            int cooldown = 0;
            boolean shouldStopUsing = false;
            if (stack.m_41720_() instanceof DiarkriteChargeBlade && (DiarkriteChargeBlade.getCharge(stack) > 2 || DiarkriteChargeBlade.isEnchantedWith(stack, ModEnchantments.SACRIFICE_CURSE) || player.m_7500_())) {
                DiarkriteChargeBlade.createBoom(level, (LivingEntity)player, stack);
                if (DiarkriteChargeBlade.isEnchantedWith(stack, ModEnchantments.SACRIFICE_CURSE)) {
                    player.m_6469_(level.m_269111_().m_269079_(ModDamageTypes.SACRIFICIAL), player.m_21233_() * (float)UniqueItemConfig.diarkriteChargeBladeSelfSacrificeDamage);
                }
                cooldown = 10;
                shouldStopUsing = true;
                player.m_21011_(hand, true);
            }
            if (stack.m_41720_() instanceof AnthektiteChargeBlade) {
                if (DiarkriteChargeBlade.isEnchantedWith(stack, ModEnchantments.RUSH) && (DiarkriteChargeBlade.getCharge(stack) >= DiarkriteChargeBlade.getChargeStack(stack) || player.m_7500_())) {
                    AnthektiteChargeBlade.rush(player);
                    DiarkriteChargeBlade.setCharge(stack, -Math.min(DiarkriteChargeBlade.getCharge(stack), DiarkriteChargeBlade.getChargeStack(stack)));
                    cooldown = 40;
                } else if (player.m_21023_((MobEffect)ModMobEffects.ElementusEffects.ANTHEKTITE_SWORD_DANCE.get())) {
                    AnthektiteChargeBlade.swordDanceSlash(player, hand);
                    cooldown = 240;
                    shouldStopUsing = true;
                    player.m_21011_(hand, true);
                } else if (!player.m_21023_((MobEffect)ModMobEffects.ElementusEffects.ANTHEKTITE_SWORD_DANCE.get()) && (DiarkriteChargeBlade.getCharge(stack) >= DiarkriteChargeBlade.getChargeStack(stack) || player.m_7500_())) {
                    player.m_7292_(new MobEffectInstance((MobEffect)ModMobEffects.ElementusEffects.ANTHEKTITE_SWORD_DANCE.get(), 600));
                    DiarkriteChargeBlade.setCharge(stack, -Math.min(DiarkriteChargeBlade.getCharge(stack), DiarkriteChargeBlade.getChargeStack(stack)));
                    cooldown = 10;
                }
            }
            if (!player.m_7500_()) {
                player.m_36335_().m_41524_(stack.m_41720_(), cooldown);
                if (shouldStopUsing) {
                    player.m_5810_();
                }
            }
        }
    }
}

