/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.common.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.nokunami.elementus.client.SteelGolemInventoryScreen;
import net.nokunami.elementus.common.entity.living.SteelGolem;
import net.nokunami.elementus.common.inventory.SteelGolemInventoryMenu;

public class SteelGolemInventoryPacket {
    private final int id;
    private final int size;
    private final int entityId;

    public SteelGolemInventoryPacket(int id, int size, int entityId) {
        this.id = id;
        this.size = size;
        this.entityId = entityId;
    }

    public static SteelGolemInventoryPacket decode(FriendlyByteBuf buf) {
        return new SteelGolemInventoryPacket(buf.readUnsignedByte(), buf.m_130242_(), buf.readInt());
    }

    public static void encode(SteelGolemInventoryPacket message, FriendlyByteBuf buf) {
        buf.writeByte(message.id);
        buf.m_130130_(message.size);
        buf.writeInt(message.entityId);
    }

    public int getId() {
        return this.id;
    }

    public int getSize() {
        return this.size;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public static void consume(SteelGolemInventoryPacket msg, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> SteelGolemInventoryPacket.openInventory(msg));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openInventory(SteelGolemInventoryPacket packet) {
        Entity entity;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && (entity = player.m_9236_().m_6815_(packet.getEntityId())) instanceof SteelGolem) {
            SteelGolem steelGolem = (SteelGolem)entity;
            LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
            SteelGolemInventoryMenu container = new SteelGolemInventoryMenu(packet.getId(), player.m_150109_(), (Container)steelGolem.inventory, steelGolem);
            localPlayer.f_36096_ = container;
            Minecraft.m_91087_().m_91152_((Screen)new SteelGolemInventoryScreen(container, player.m_150109_(), steelGolem));
        }
    }
}

