/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.common.worldgen.tree;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.nokunami.elementus.common.Etags;
import net.nokunami.elementus.common.registry.ModBlocks;
import net.nokunami.elementus.common.worldgen.tree.ModTrunkPlacer;
import org.jetbrains.annotations.NotNull;

public class MegaMovcadiaTrunkPlacer
extends TrunkPlacer {
    public static final Codec<MegaMovcadiaTrunkPlacer> CODEC = RecordCodecBuilder.create(megaMovcadiaTrunkPlacerInstance -> MegaMovcadiaTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)megaMovcadiaTrunkPlacerInstance).apply((Applicative)megaMovcadiaTrunkPlacerInstance, MegaMovcadiaTrunkPlacer::new));
    private static final BlockStateProvider rootedDirt = BlockStateProvider.m_191382_((Block)((Block)ModBlocks.ElementusBlocks.MOVCADIA_ROOTED_DIRT.get()));
    private static final BlockStateProvider rootedStone = BlockStateProvider.m_191382_((Block)((Block)ModBlocks.ElementusBlocks.MOVCADIA_ROOTED_STONE.get()));
    private static final BlockStateProvider rootedDeepslate = BlockStateProvider.m_191382_((Block)((Block)ModBlocks.ElementusBlocks.MOVCADIA_ROOTED_DEEPSLATE.get()));

    public MegaMovcadiaTrunkPlacer(int pBaseHeight, int pHeightRandA, int pHeightRandB) {
        super(pBaseHeight, pHeightRandA, pHeightRandB);
    }

    @NotNull
    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)ModTrunkPlacer.MEGA_MOVCADIA_TRUNK_PLACER.get();
    }

    private static boolean m_70295_(LevelSimulatedReader pLevel, BlockPos pPos) {
        return pLevel.m_7433_(pPos, blockState -> blockState.m_204336_(Etags.Blocks.MOVCADIA_ROOTED_DIRT));
    }

    private static boolean isStone(LevelSimulatedReader pLevel, BlockPos pPos) {
        return pLevel.m_7433_(pPos, blockState -> blockState.m_204336_(Etags.Blocks.MOVCADIA_ROOTED_STONE));
    }

    private static boolean isDeepslate(LevelSimulatedReader pLevel, BlockPos pPos) {
        return pLevel.m_7433_(pPos, blockState -> blockState.m_204336_(Etags.Blocks.MOVCADIA_ROOTED_DEEPSLATE));
    }

    protected static void setBlock(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos pos, TreeConfiguration config) {
        if (((LevelReader)level).m_8055_(pos).onTreeGrow((LevelReader)level, blockSetter, random, pos, config)) {
            if (MegaMovcadiaTrunkPlacer.m_70295_(level, pos)) {
                blockSetter.accept(pos, rootedDirt.m_213972_(random, pos));
            } else if (MegaMovcadiaTrunkPlacer.isStone(level, pos)) {
                blockSetter.accept(pos, rootedStone.m_213972_(random, pos));
            } else if (MegaMovcadiaTrunkPlacer.isDeepslate(level, pos)) {
                blockSetter.accept(pos, rootedDeepslate.m_213972_(random, pos));
            }
        }
    }

    @NotNull
    public List<FoliagePlacer.FoliageAttachment> m_213934_(@NotNull LevelSimulatedReader pLevel, @NotNull BiConsumer<BlockPos, BlockState> pBlockSetter, @NotNull RandomSource pRandom, int pFreeTreeHeight, BlockPos pPos, @NotNull TreeConfiguration pConfig) {
        int k2;
        int i3;
        int l2;
        ArrayList list = Lists.newArrayList();
        BlockPos blockpos = pPos.m_7495_();
        MegaMovcadiaTrunkPlacer.m_226169_((LevelSimulatedReader)pLevel, pBlockSetter, (RandomSource)pRandom, (BlockPos)pPos.m_7495_(), (TreeConfiguration)pConfig);
        MegaMovcadiaTrunkPlacer.m_226169_((LevelSimulatedReader)pLevel, pBlockSetter, (RandomSource)pRandom, (BlockPos)pPos.m_7495_().m_122029_(), (TreeConfiguration)pConfig);
        MegaMovcadiaTrunkPlacer.m_226169_((LevelSimulatedReader)pLevel, pBlockSetter, (RandomSource)pRandom, (BlockPos)pPos.m_7495_().m_122019_(), (TreeConfiguration)pConfig);
        MegaMovcadiaTrunkPlacer.m_226169_((LevelSimulatedReader)pLevel, pBlockSetter, (RandomSource)pRandom, (BlockPos)pPos.m_7495_().m_122019_().m_122029_(), (TreeConfiguration)pConfig);
        Direction direction = Direction.Plane.HORIZONTAL.m_235690_(pRandom);
        int i = pFreeTreeHeight - pRandom.m_188503_(4);
        int j = 2 - pRandom.m_188503_(3);
        int k = blockpos.m_123341_();
        int l = blockpos.m_123342_();
        int i1 = blockpos.m_123343_();
        int j1 = k;
        int k1 = i1;
        int l1 = l + pFreeTreeHeight - 1;
        for (int mainTrunk = 0; mainTrunk < pFreeTreeHeight; ++mainTrunk) {
            int j2;
            BlockPos blockpos1;
            if (mainTrunk > i && j > 0) {
                j1 += direction.m_122429_();
                k1 += direction.m_122431_();
                --j;
            }
            if (!TreeFeature.m_67267_((LevelSimulatedReader)pLevel, (BlockPos)(blockpos1 = new BlockPos(j1, j2 = l + mainTrunk, k1)))) continue;
            this.m_226187_(pLevel, pBlockSetter, pRandom, blockpos1, pConfig);
            this.m_226187_(pLevel, pBlockSetter, pRandom, blockpos1.m_122029_(), pConfig);
            this.m_226187_(pLevel, pBlockSetter, pRandom, blockpos1.m_122019_(), pConfig);
            this.m_226187_(pLevel, pBlockSetter, pRandom, blockpos1.m_122019_().m_122029_(), pConfig);
        }
        list.add(new FoliagePlacer.FoliageAttachment(new BlockPos(j1, l1, k1), 0, false));
        for (l2 = -1; l2 <= 2; ++l2) {
            for (i3 = -1; i3 <= 2; ++i3) {
                if (l2 >= 0 && l2 <= 1 && i3 >= 0 && i3 <= 1 || pRandom.m_188503_(1) > 0) continue;
                int j3 = pRandom.m_188503_(8) + 3;
                for (k2 = 0; k2 < j3; ++k2) {
                    this.m_226187_(pLevel, pBlockSetter, pRandom, new BlockPos(k + l2, l1 - k2 - 1, i1 + i3), pConfig);
                }
                list.add(new FoliagePlacer.FoliageAttachment(new BlockPos(j1 + l2, l1, k1 + 1), 0, false));
            }
        }
        for (l2 = -2; l2 <= 3; ++l2) {
            for (i3 = -2; i3 <= 3; ++i3) {
                if (l2 >= 0 && l2 <= 1 && i3 >= 0 && i3 <= 1 || pRandom.m_188503_(2) > 0) continue;
                int j3 = pRandom.m_188503_(2) + 3;
                for (k2 = 0; k2 < j3; ++k2) {
                    this.m_226187_(pLevel, pBlockSetter, pRandom, new BlockPos(k + l2, l1 - k2 - 1, i1 + i3), pConfig);
                }
            }
        }
        return list;
    }
}

