/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.nokunami.elementus.ModChecker;
import net.nokunami.elementus.datagen.DatapackEntriesBuilder;
import net.nokunami.elementus.datagen.generators.ModBlockStateData;
import net.nokunami.elementus.datagen.generators.ModBlockTagsData;
import net.nokunami.elementus.datagen.generators.ModDamageTypeTagsData;
import net.nokunami.elementus.datagen.generators.ModEntityTypeTags;
import net.nokunami.elementus.datagen.generators.ModItemModelData;
import net.nokunami.elementus.datagen.generators.ModItemTagsData;
import net.nokunami.elementus.datagen.generators.ModLootTableData;
import net.nokunami.elementus.datagen.generators.ModRecipeData;
import net.nokunami.elementus.datagen.generators.PECustomConversionData;
import net.nokunami.elementus.datagen.generators.create.CreateProcessingRecipe;
import net.nokunami.elementus.datagen.providers.ModGlobalLootModifierProvider;

@Mod.EventBusSubscriber(modid="elementus", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockStateData(packOutput, "elementus", existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelData(packOutput, "elementus", existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModDamageTypeTagsData(packOutput, lookupProvider, "elementus", existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeData(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)ModLootTableData.create(packOutput));
        ModBlockTagsData blockTagGenerator = (ModBlockTagsData)generator.addProvider(event.includeServer(), (DataProvider)new ModBlockTagsData(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagsData(packOutput, lookupProvider, blockTagGenerator.m_274426_(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModEntityTypeTags(packOutput, lookupProvider, existingFileHelper));
        if (ModChecker.advancedNetherite) {
            generator.addProvider(event.includeServer(), (DataProvider)new ModGlobalLootModifierProvider(packOutput));
        }
        generator.addProvider(event.includeServer(), (DataProvider)new DatapackEntriesBuilder(packOutput, lookupProvider));
        if (ModChecker.projectE) {
            generator.addProvider(event.includeServer(), (DataProvider)new PECustomConversionData(packOutput, lookupProvider));
        }
        CreateProcessingRecipe.registerAll(generator, packOutput);
    }
}

