/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.datagen.providers;

import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import vectorwing.farmersdelight.common.block.CabinetBlock;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, String modid, ExistingFileHelper exFileHelper) {
        super(output, modid, exFileHelper);
    }

    protected void registerStatesAndModels() {
    }

    public String name(Block block) {
        ResourceLocation location = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (location != null) {
            return location.m_135815_();
        }
        throw new IllegalStateException("Unknown block: " + block.toString());
    }

    public ResourceLocation texture(String name) {
        return this.modLoc("block/" + name);
    }

    public ResourceLocation texture(String name, String location) {
        return this.modLoc("block/" + location + name);
    }

    public ResourceLocation texture(String name, String location, String suffix) {
        return this.modLoc("block/" + location + name + suffix);
    }

    public ResourceLocation extend(ResourceLocation location, String suffix) {
        return new ResourceLocation(location.m_135827_(), location.m_135815_() + suffix);
    }

    public void block(Supplier<? extends Block> block, String location) {
        this.simpleBlock(block.get(), this.cubeAll(block.get(), location));
    }

    public void transparentBlock(Supplier<? extends Block> block, String location) {
        this.simpleBlock(block.get(), this.cubeAllCutOut(block.get(), location));
    }

    public void columnBlock(Supplier<? extends Block> block, Supplier<? extends Block> endBlock, String location) {
        ModelBuilder bookshelf = this.models().cubeColumn(this.name(block.get()), this.texture(this.name(block.get()) + "_side", location), this.texture(this.name(endBlock.get()) + "_end", location));
        this.getVariantBuilder(block.get()).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)bookshelf)});
    }

    public ModelFile cubeAll(Block block, String location) {
        return this.models().cubeAll(this.name(block), this.texture(this.name(block), location));
    }

    public ModelFile cubeAllCutOut(Block block, String location) {
        return ((BlockModelBuilder)this.models().cubeAll(this.name(block), this.texture(this.name(block), location))).renderType("cutout");
    }

    public void log(Supplier<? extends RotatedPillarBlock> block, String location) {
        this.axisBlock(block.get(), this.texture(this.name((Block)block.get()), location), this.extend(this.texture(this.name((Block)block.get()), location), "_top"));
    }

    public void wood(Supplier<? extends RotatedPillarBlock> block, Supplier<? extends RotatedPillarBlock> baseBlock, String location) {
        this.axisBlock(block.get(), this.texture(this.name((Block)baseBlock.get()), location), this.texture(this.name((Block)baseBlock.get()), location));
    }

    public void stairs(Supplier<? extends Block> block, Supplier<? extends Block> baseBlock, String location) {
        this.stairsBlock((StairBlock)block.get(), this.texture(this.name(baseBlock.get()), location));
    }

    public void slab(Supplier<? extends Block> block, Supplier<? extends Block> baseBlock, String location) {
        this.slabBlock((SlabBlock)block.get(), this.texture(this.name(baseBlock.get())), this.texture(this.name(baseBlock.get()), location));
    }

    public void fence(Supplier<? extends FenceBlock> block, Supplier<? extends Block> baseBlock, String location) {
        this.fenceBlock(block.get(), this.texture(this.name(baseBlock.get()), location));
        this.fenceColumn((CrossCollisionBlock)block.get(), this.name(baseBlock.get()), location);
    }

    public void fenceColumn(CrossCollisionBlock block, String side, String location) {
        String baseName = this.name((Block)block);
        this.fourWayBlock(block, (ModelFile)this.models().fencePost(baseName + "_post", this.texture(side, location)), (ModelFile)this.models().fenceSide(baseName + "_side", this.texture(side, location)));
    }

    public void fenceGateBlock(Supplier<? extends FenceGateBlock> block, Supplier<? extends Block> baseBlock, String location) {
        this.fenceGateBlockInternal(block.get(), this.name((Block)block.get()), this.texture(this.name(baseBlock.get()), location));
    }

    public void fenceGateBlockInternal(FenceGateBlock block, String baseName, ResourceLocation texture) {
        ModelBuilder gate = this.models().fenceGate(baseName, texture);
        ModelBuilder gateOpen = this.models().fenceGateOpen(baseName + "_open", texture);
        ModelBuilder gateWall = this.models().fenceGateWall(baseName + "_wall", texture);
        ModelBuilder gateWallOpen = this.models().fenceGateWallOpen(baseName + "_wall_open", texture);
        this.fenceGateBlock(block, (ModelFile)gate, (ModelFile)gateOpen, (ModelFile)gateWall, (ModelFile)gateWallOpen);
    }

    public void doorBlock(Supplier<? extends DoorBlock> block, ResourceLocation bottom, ResourceLocation top) {
        this.doorBlockWithRenderType(block.get(), bottom, top, "cutout");
    }

    public void trapdoorBlock(Supplier<? extends TrapDoorBlock> block, ResourceLocation texture, boolean orientable) {
        this.trapdoorBlockWithRenderType(block.get(), texture, orientable, "cutout");
    }

    public void pressurePlateBlock(Supplier<? extends PressurePlateBlock> block, ResourceLocation texture) {
        ModelBuilder pressurePlate = this.models().pressurePlate(this.name((Block)block.get()), texture);
        ModelBuilder pressurePlateDown = this.models().pressurePlateDown(this.name((Block)block.get()) + "_down", texture);
        this.pressurePlateBlock(block.get(), (ModelFile)pressurePlate, (ModelFile)pressurePlateDown);
    }

    public void buttonBlock(Supplier<? extends ButtonBlock> block, ResourceLocation texture) {
        ModelBuilder button = this.models().button(this.name((Block)block.get()), texture);
        ModelBuilder buttonPressed = this.models().buttonPressed(this.name((Block)block.get()) + "_pressed", texture);
        this.buttonBlock(block.get(), (ModelFile)button, (ModelFile)buttonPressed);
    }

    public void signBlock(StandingSignBlock signBlock, WallSignBlock wallSignBlock, ResourceLocation texture) {
        ModelBuilder sign = this.models().sign(this.name((Block)signBlock), texture);
        this.signBlock(signBlock, wallSignBlock, (ModelFile)sign);
    }

    public void hangingSignBlock(CeilingHangingSignBlock signBlock, WallHangingSignBlock wallSignBlock, ResourceLocation texture) {
        ModelBuilder sign = this.models().sign(this.name((Block)signBlock), texture);
        this.simpleBlock((Block)signBlock, (ModelFile)sign);
        this.simpleBlock((Block)wallSignBlock, (ModelFile)sign);
    }

    public void saplingBlock(Supplier<? extends Block> block, String location) {
        ModelBuilder sapling = ((BlockModelBuilder)this.models().cross(this.name(block.get()), this.texture(this.name(block.get()), location))).renderType(new ResourceLocation("cutout"));
        this.getVariantBuilder(block.get()).forAllStatesExcept(arg_0 -> ModBlockStateProvider.lambda$saplingBlock$0((ModelFile)sapling, arg_0), new Property[]{SaplingBlock.f_55973_});
    }

    public void chestModel(Block block, ModelFile chest) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile(chest).build(), new Property[]{ChestBlock.f_51479_, ChestBlock.f_51480_});
    }

    public void chest(Supplier<? extends Block> block, Supplier<? extends Block> dummyBlock, String location) {
        ModelBuilder chest = this.models().cubeAll(this.name(block.get()), this.texture(this.name(dummyBlock.get()), location));
        this.chestModel(block.get(), (ModelFile)chest);
    }

    public void transparentColumnBlock(Supplier<? extends Block> block, Supplier<? extends Block> endBlock, String location) {
        ModelBuilder bookshelf = ((BlockModelBuilder)this.models().cubeColumn(this.name(block.get()), this.texture(this.name(block.get()) + "_side", location), this.texture(this.name(endBlock.get()) + "_end", location))).renderType("cutout");
        this.getVariantBuilder(block.get()).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)bookshelf)});
    }

    public void cabinetBlock(Block block, String woodType) {
        this.horizontalBlock(block, state -> {
            String suffix = (Boolean)state.m_61143_((Property)CabinetBlock.OPEN) != false ? "_open" : "";
            return this.models().orientable(this.name(block) + suffix, this.texture(woodType + "_cabinet_side"), this.texture(woodType + "_cabinet_front" + suffix), this.texture(woodType + "_cabinet_top"));
        });
    }

    private static /* synthetic */ ConfiguredModel[] lambda$saplingBlock$0(ModelFile sapling, BlockState state) {
        return ConfiguredModel.builder().modelFile(sapling).build();
    }
}

