/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.datagen.providers;

import com.aetherteam.aether.item.accessories.gloves.GlovesItem;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.loaders.ItemLayerModelBuilder;
import net.minecraftforge.client.model.generators.loaders.SeparateTransformsModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.nokunami.elementus.ModChecker;
import net.nokunami.elementus.datagen.ModTrimMaterials;

public class ModItemModelProvider
extends ItemModelProvider {
    protected static final List<ResourceKey<TrimMaterial>> VANILLA_TRIM_MATERIALS = List.of(TrimMaterials.f_265905_, TrimMaterials.f_266000_, TrimMaterials.f_265896_, TrimMaterials.f_265870_, TrimMaterials.f_265969_, TrimMaterials.f_265937_, TrimMaterials.f_266071_, TrimMaterials.f_266027_, TrimMaterials.f_265981_, TrimMaterials.f_265872_, ModTrimMaterials.STEEL, ModTrimMaterials.DIARKRITE, ModTrimMaterials.ANTHEKTITE);

    public ModItemModelProvider(PackOutput output, String modid, ExistingFileHelper existingFileHelper) {
        super(output, modid, existingFileHelper);
    }

    protected void registerModels() {
    }

    public String itemName(Item item) {
        ResourceLocation location = ForgeRegistries.ITEMS.getKey((Object)item);
        if (location != null) {
            return location.m_135815_();
        }
        throw new IllegalStateException("Unknown item: " + item.toString());
    }

    protected String blockName(Supplier<? extends Block> block) {
        return Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block.get())).m_135815_();
    }

    protected ResourceLocation texture(String name) {
        return this.modLoc("block/" + name);
    }

    protected ResourceLocation texture(String name, String location) {
        return this.modLoc("block/" + location + name);
    }

    public void generatedItem(Supplier<? extends Item> item, String location) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + location + "/" + this.itemName(item.get())));
    }

    public void handheldItem(Supplier<? extends Item> item, String location) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()), this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + location + "/" + this.itemName(item.get())));
    }

    public void itemCustomParentModel(Supplier<? extends Item> item, String location, String parentModel) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()), this.modLoc(parentModel))).texture("layer0", this.modLoc("item/" + location + "/" + this.itemName(item.get())));
    }

    public void itemCustomParentModel(Supplier<? extends Item> item, String parentModel) {
        this.withExistingParent(this.itemName(item.get()), this.modLoc(parentModel));
    }

    public void spawnEggItem(Supplier<? extends Item> item) {
        this.withExistingParent(this.itemName(item.get()), this.mcLoc("item/template_spawn_egg"));
    }

    public void bowItem(Supplier<? extends Item> item, String location) {
        int i;
        for (i = 0; i < 3; ++i) {
            ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + "_pulling_" + i, this.mcLoc("item/bow"))).texture("layer0", this.modLoc("item/" + location + "/" + this.itemName(item.get()) + "_pulling_" + i))).texture("layer1", this.modLoc("item/" + location + "/arrow_pulling_" + i));
        }
        for (i = 0; i < 3; ++i) {
            ((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + "_drawing_" + i, this.mcLoc("item/bow"))).texture("layer0", this.modLoc("item/" + location + "/" + this.itemName(item.get()) + "_pulling_" + i));
        }
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()), this.mcLoc("item/bow"))).texture("layer0", this.modLoc("item/" + location + "/" + this.itemName(item.get())))).override().predicate(new ResourceLocation("pulling"), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_pulling_0"))).end().override().predicate(new ResourceLocation("pulling"), 1.0f).predicate(new ResourceLocation("pull"), 0.65f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_pulling_1"))).end().override().predicate(new ResourceLocation("pulling"), 1.0f).predicate(new ResourceLocation("pull"), 0.9f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_pulling_2"))).end().override().predicate(new ResourceLocation("drawing"), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_drawing_0"))).end().override().predicate(new ResourceLocation("drawing"), 1.0f).predicate(new ResourceLocation("draw"), 0.65f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_drawing_1"))).end().override().predicate(new ResourceLocation("drawing"), 1.0f).predicate(new ResourceLocation("draw"), 0.9f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_drawing_2"))).end();
    }

    public void chargerItem(Supplier<? extends Item> item, String location) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + "_gui", this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + location + "/" + this.itemName(item.get())));
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + "_gui_charge_0", this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + location + "/" + this.itemName(item.get()) + "_charge_0"));
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + "_gui_charge_1", this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + location + "/" + this.itemName(item.get()) + "_charge_1"));
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + "_gui_charge_2", this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + location + "/" + this.itemName(item.get()) + "_charge_2"));
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + "_handheld", this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + location + "/" + this.itemName(item.get()) + "_handheld"));
        ((ItemLayerModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + "_handheld_charge_0", this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + location + "/" + this.itemName(item.get()) + "_handheld_charge_0"))).texture("layer1", this.modLoc("item/" + location + "/" + this.itemName(item.get()) + "_handheld_charge_0_emissive"))).customLoader(ItemLayerModelBuilder::begin)).emissive(15, 15, new int[]{1}).end();
        ((ItemLayerModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + "_handheld_charge_1", this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + location + "/" + this.itemName(item.get()) + "_handheld_charge_1"))).texture("layer1", this.modLoc("item/" + location + "/" + this.itemName(item.get()) + "_handheld_charge_1_emissive"))).customLoader(ItemLayerModelBuilder::begin)).emissive(15, 15, new int[]{1}).end();
        ((ItemLayerModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + "_handheld_charge_2", this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + location + "/" + this.itemName(item.get()) + "_handheld_charge_2"))).texture("layer1", this.modLoc("item/" + location + "/" + this.itemName(item.get()) + "_handheld_charge_2_emissive"))).customLoader(ItemLayerModelBuilder::begin)).emissive(15, 15, new int[]{1}).end();
        ((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + "_charge_0", new ResourceLocation("handheld"))).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(String.valueOf(item.get()) + "_handheld_charge_0", this.modLoc("item/claymore_item"))))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(this.itemName(item.get()) + "_gui_charge_0", this.mcLoc("generated"))))).end();
        ((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + "_charge_1", new ResourceLocation("handheld"))).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(String.valueOf(item.get()) + "_handheld_charge_1", this.modLoc("item/claymore_item"))))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(this.itemName(item.get()) + "_gui_charge_1", this.mcLoc("generated"))))).end();
        ((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + "_charge_2", new ResourceLocation("handheld"))).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(String.valueOf(item.get()) + "_handheld_charge_2", this.modLoc("item/claymore_item"))))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(this.itemName(item.get()) + "_gui_charge_2", this.mcLoc("generated"))))).end();
        ((ItemModelBuilder)((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()), new ResourceLocation("handheld"))).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(String.valueOf(item.get()) + "_handheld", this.modLoc("item/claymore_item"))))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(this.itemName(item.get()) + "_gui", this.mcLoc("generated"))))).perspective(ItemDisplayContext.FIXED, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(this.itemName(item.get()) + "_gui", this.mcLoc("generated"))))).perspective(ItemDisplayContext.GROUND, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(this.itemName(item.get()) + "_gui", this.mcLoc("generated"))))).end()).override().predicate(new ResourceLocation("pulling"), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_charge_0"))).end().override().predicate(new ResourceLocation("pulling"), 1.0f).predicate(new ResourceLocation("pull"), 0.65f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_charge_1"))).end().override().predicate(new ResourceLocation("pulling"), 1.0f).predicate(new ResourceLocation("pull"), 0.9f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_charge_2"))).end();
    }

    public void movcadiaTools(Supplier<? extends Item> item, String location) {
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()), this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + location + "/" + this.itemName(item.get())))).override().predicate(this.modLoc("empowered"), 1.0f).model((ModelFile)((ItemLayerModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + "_empowered", this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + location + "/" + this.itemName(item.get()) + "_empowered"))).texture("layer1", this.modLoc("item/" + location + "/" + this.itemName(item.get()) + "_empowered_e"))).customLoader(ItemLayerModelBuilder::begin)).emissive(15, 15, new int[]{1}).end()).end();
    }

    public void diarkriteChargeBlade(Supplier<? extends Item> item, String location) {
        String sacrifice = "sacrifice";
        this.chargedWeaponModel(item, "_gui_charge_", this.mcLoc("item/handheld"), location, "_charge_", 5);
        this.chargedWeaponModel(item, "_handheld_charge_", this.modLoc("item/claymore_item"), location, "_handheld_charge_", 5);
        this.chargedWeaponBlockingModel(item, "_handheld_charge_", this.modLoc("item/claymore_item_blocking"), location, "_handheld_charge_", 5);
        this.handheldGuiModel(item, "_charge_", this.mcLoc("item/handheld"), "_handheld_charge_", "_gui_charge_", 5);
        this.handheldGuiBlockingModel(item, "_charge_", this.modLoc("item/claymore_item_blocking"), "_handheld_charge_", "_gui_charge_", 5);
        this.chargedWeaponModel(item, "_" + sacrifice + "_gui_charge_", this.mcLoc("item/handheld"), location, "_" + sacrifice + "_charge_", 5);
        this.chargedWeaponModel(item, "_" + sacrifice + "_handheld_charge_", this.modLoc("item/claymore_item"), location, "_" + sacrifice + "_handheld_charge_", 5);
        this.chargedWeaponBlockingModel(item, "_" + sacrifice + "_handheld_charge_", this.modLoc("item/claymore_item_blocking"), location, "_" + sacrifice + "_handheld_charge_", 5);
        this.handheldGuiModel(item, "_" + sacrifice + "_charge_", this.modLoc("item/claymore_item"), "_" + sacrifice + "_handheld_charge_", "_" + sacrifice + "_gui_charge_", 5);
        this.handheldGuiBlockingModel(item, "_" + sacrifice + "_charge_", this.modLoc("item/claymore_item_blocking"), "_" + sacrifice + "_handheld_charge_", "_" + sacrifice + "_gui_charge_", 5);
        this.baseModels(item, "_gui", "_handheld", this.modLoc("item/claymore_item"), "_handheld_blocking", this.modLoc("item/claymore_item_blocking"), location);
        this.baseModels(item, sacrifice, "_" + sacrifice + "_gui", "_" + sacrifice + "_handheld", this.modLoc("item/claymore_item"), "_" + sacrifice + "_handheld_blocking", this.modLoc("item/claymore_item_blocking"), location);
        this.baseModels(item, "multi", "_multi_gui", "_multi_handheld", this.modLoc("item/claymore_item"), "_multi_handheld_blocking", this.modLoc("item/claymore_item_blocking"), location);
        ((ItemModelBuilder)((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()), this.modLoc("item/claymore_item"))).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_base"))))).end()).override().predicate(this.mcLoc("blocking"), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_blocking"))).end().override().predicate(this.modLoc(sacrifice), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_" + sacrifice + "_base"))).end().override().predicate(this.mcLoc("blocking"), 1.0f).predicate(this.modLoc(sacrifice), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_" + sacrifice + "_blocking"))).end().override().predicate(this.modLoc("charge"), 0.16f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_charge_0"))).end().override().predicate(this.mcLoc("blocking"), 1.0f).predicate(this.modLoc("charge"), 0.16f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_charge_0_blocking"))).end().override().predicate(this.modLoc("charge"), 0.32f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_charge_1"))).end().override().predicate(this.mcLoc("blocking"), 1.0f).predicate(this.modLoc("charge"), 0.32f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_charge_1_blocking"))).end().override().predicate(this.modLoc("charge"), 0.48f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_charge_2"))).end().override().predicate(this.mcLoc("blocking"), 1.0f).predicate(this.modLoc("charge"), 0.48f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_charge_2_blocking"))).end().override().predicate(this.modLoc("charge"), 0.64f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_charge_3"))).end().override().predicate(this.mcLoc("blocking"), 1.0f).predicate(this.modLoc("charge"), 0.64f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_charge_3_blocking"))).end().override().predicate(this.modLoc("charge"), 0.8f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_charge_4"))).end().override().predicate(this.mcLoc("blocking"), 1.0f).predicate(this.modLoc("charge"), 0.8f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_charge_4_blocking"))).end().override().predicate(this.modLoc("charge"), 0.2f).predicate(this.modLoc(sacrifice), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_" + sacrifice + "_charge_0"))).end().override().predicate(this.mcLoc("blocking"), 1.0f).predicate(this.modLoc("charge"), 0.16f).predicate(this.modLoc(sacrifice), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_" + sacrifice + "_charge_0_blocking"))).end().override().predicate(this.modLoc("charge"), 0.4f).predicate(this.modLoc(sacrifice), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_" + sacrifice + "_charge_1"))).end().override().predicate(this.mcLoc("blocking"), 1.0f).predicate(this.modLoc("charge"), 0.32f).predicate(this.modLoc(sacrifice), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_" + sacrifice + "_charge_1_blocking"))).end().override().predicate(this.modLoc("charge"), 0.6f).predicate(this.modLoc(sacrifice), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_" + sacrifice + "_charge_2"))).end().override().predicate(this.mcLoc("blocking"), 1.0f).predicate(this.modLoc("charge"), 0.48f).predicate(this.modLoc(sacrifice), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_" + sacrifice + "_charge_2_blocking"))).end().override().predicate(this.modLoc("charge"), 0.8f).predicate(this.modLoc(sacrifice), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_" + sacrifice + "_charge_3"))).end().override().predicate(this.mcLoc("blocking"), 1.0f).predicate(this.modLoc("charge"), 0.64f).predicate(this.modLoc(sacrifice), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_" + sacrifice + "_charge_3_blocking"))).end().override().predicate(this.modLoc("charge"), 0.8f).predicate(this.modLoc(sacrifice), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_" + sacrifice + "_charge_4"))).end().override().predicate(this.mcLoc("blocking"), 1.0f).predicate(this.modLoc("charge"), 0.8f).predicate(this.modLoc(sacrifice), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_" + sacrifice + "_charge_4_blocking"))).end();
    }

    public void anthektiteLongsword(Supplier<? extends Item> item, String location) {
        this.chargedWeaponModel(item, "_gui_charge_", this.mcLoc("item/handheld"), location, "_charge_", 4);
        this.chargedWeaponModel(item, "_handheld_charge_", this.modLoc("item/claymore_item"), location, "_handheld_charge_", 4);
        this.chargedWeaponBlockingModel(item, "_handheld_charge_", this.modLoc("item/claymore_item_blocking"), location, "_handheld_charge_", 4);
        this.handheldGuiModel(item, "_charge_", this.mcLoc("item/handheld"), "_handheld_charge_", "_gui_charge_", 4);
        this.handheldGuiBlockingModel(item, "_charge_", this.modLoc("item/claymore_item_blocking"), "_handheld_charge_", "_gui_charge_", 4);
        this.baseModels(item, "_gui", "_handheld", this.modLoc("item/claymore_item"), "_handheld_blocking", this.modLoc("item/claymore_item_blocking"), location);
        ((ItemModelBuilder)((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()), this.modLoc("item/claymore_item"))).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_base"))))).end()).override().predicate(this.mcLoc("blocking"), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_blocking"))).end().override().predicate(this.modLoc("charge"), 0.2f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_charge_0"))).end().override().predicate(this.mcLoc("blocking"), 1.0f).predicate(this.modLoc("charge"), 0.2f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_charge_0_blocking"))).end().override().predicate(this.modLoc("charge"), 0.4f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_charge_1"))).end().override().predicate(this.mcLoc("blocking"), 1.0f).predicate(this.modLoc("charge"), 0.4f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_charge_1_blocking"))).end().override().predicate(this.modLoc("charge"), 0.6f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_charge_2"))).end().override().predicate(this.mcLoc("blocking"), 1.0f).predicate(this.modLoc("charge"), 0.6f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_charge_2_blocking"))).end().override().predicate(this.modLoc("charge"), 0.8f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_charge_3"))).end().override().predicate(this.mcLoc("blocking"), 1.0f).predicate(this.modLoc("charge"), 0.8f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_charge_3_blocking"))).end();
    }

    private void repeating1LayerModel(Supplier<? extends Item> item, String extension, ResourceLocation itemModel, String location, int loopCount) {
        for (int i = 0; i < loopCount; ++i) {
            ((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + extension + i, itemModel)).texture("layer0", this.modLoc("item/" + location + "/" + this.itemName(item.get()) + extension + i));
        }
    }

    private void chargedWeaponModel(Supplier<? extends Item> item, String extension, ResourceLocation itemModel, String location, String texture_extension, int loopCount) {
        for (int i = 0; i < loopCount; ++i) {
            ((ItemLayerModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + extension + i, itemModel)).texture("layer0", this.modLoc("item/" + location + "/" + this.itemName(item.get()) + texture_extension + i))).texture("layer1", this.modLoc("item/" + location + "/" + this.itemName(item.get()) + texture_extension + i + "_e"))).customLoader(ItemLayerModelBuilder::begin)).emissive(15, 15, new int[]{1});
        }
    }

    private void chargedWeaponBlockingModel(Supplier<? extends Item> item, String extension, ResourceLocation itemModel, String location, String texture_extension, int loopCount) {
        for (int i = 0; i < loopCount; ++i) {
            ((ItemLayerModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + extension + i + "_blocking", itemModel)).texture("layer0", this.modLoc("item/" + location + "/" + this.itemName(item.get()) + texture_extension + i))).texture("layer1", this.modLoc("item/" + location + "/" + this.itemName(item.get()) + texture_extension + i + "_e"))).customLoader(ItemLayerModelBuilder::begin)).emissive(15, 15, new int[]{1});
        }
    }

    private void handheldGuiModel(Supplier<? extends Item> item, String extension, ResourceLocation itemModel, String baseExtension, String guiExtension, int loopCount) {
        for (int i = 0; i < loopCount; ++i) {
            ((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + extension + i, itemModel)).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc(String.valueOf(item.get()) + baseExtension + i))))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc(String.valueOf(item.get()) + guiExtension + i))))).perspective(ItemDisplayContext.FIXED, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc(String.valueOf(item.get()) + guiExtension + i))))).perspective(ItemDisplayContext.GROUND, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc(String.valueOf(item.get()) + guiExtension + i))))).end();
        }
    }

    private void handheldGuiBlockingModel(Supplier<? extends Item> item, String extension, ResourceLocation itemModel, String baseExtension, String guiExtension, int loopCount) {
        for (int i = 0; i < loopCount; ++i) {
            ((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + extension + i + "_blocking", itemModel)).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc(String.valueOf(item.get()) + baseExtension + i + "_blocking"))))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc(String.valueOf(item.get()) + guiExtension + i))))).perspective(ItemDisplayContext.FIXED, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc(String.valueOf(item.get()) + guiExtension + i))))).perspective(ItemDisplayContext.GROUND, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc(String.valueOf(item.get()) + guiExtension + i))))).end();
        }
    }

    private void baseModels(Supplier<? extends Item> item, String guiEx, String handheldEx, ResourceLocation handheldModel, String location) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + guiEx, this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + location + "/" + this.itemName(item.get())));
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + handheldEx, handheldModel)).texture("layer0", this.modLoc("item/" + location + "/" + this.itemName(item.get()) + "_handheld"));
        ((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + "_base", handheldEx)).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc(String.valueOf(item.get()) + handheldEx))))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc(String.valueOf(item.get()) + guiEx))))).perspective(ItemDisplayContext.FIXED, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc(String.valueOf(item.get()) + guiEx))))).perspective(ItemDisplayContext.GROUND, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc(String.valueOf(item.get()) + guiEx))))).end();
    }

    private void baseModels(Supplier<? extends Item> item, String extension, String guiEx, String handheldEx, ResourceLocation handheldModel, String location) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + guiEx, this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + location + "/" + this.itemName(item.get())));
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + handheldEx, handheldModel)).texture("layer0", this.modLoc("item/" + location + "/" + this.itemName(item.get()) + "_handheld"));
        ((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + "_" + extension + "_base", handheldEx)).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc(String.valueOf(item.get()) + handheldEx))))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc(String.valueOf(item.get()) + guiEx))))).perspective(ItemDisplayContext.FIXED, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc(String.valueOf(item.get()) + guiEx))))).perspective(ItemDisplayContext.GROUND, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc(String.valueOf(item.get()) + guiEx))))).end();
    }

    private void baseModels(Supplier<? extends Item> item, String guiEx, String handheldEx, ResourceLocation handheldModel, String blockingEx, ResourceLocation blockingModel, String location) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + guiEx, this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + location + "/" + this.itemName(item.get())));
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + handheldEx, handheldModel)).texture("layer0", this.modLoc("item/" + location + "/" + this.itemName(item.get()) + "_handheld"));
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + blockingEx, blockingModel)).texture("layer0", this.modLoc("item/" + location + "/" + this.itemName(item.get()) + "_handheld"));
        ((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + "_base", handheldModel)).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc(String.valueOf(item.get()) + handheldEx))))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc(String.valueOf(item.get()) + guiEx))))).perspective(ItemDisplayContext.FIXED, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc(String.valueOf(item.get()) + guiEx))))).perspective(ItemDisplayContext.GROUND, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc(String.valueOf(item.get()) + guiEx))))).end();
        ((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + "_blocking", blockingModel)).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc(String.valueOf(item.get()) + blockingEx))))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc(String.valueOf(item.get()) + guiEx))))).perspective(ItemDisplayContext.FIXED, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc(String.valueOf(item.get()) + guiEx))))).perspective(ItemDisplayContext.GROUND, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc(String.valueOf(item.get()) + guiEx))))).end();
    }

    private void baseModels(Supplier<? extends Item> item, String extension, String guiEx, String handheldEx, ResourceLocation handheldModel, String blockingEx, ResourceLocation blockingModel, String location) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + guiEx, this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + location + "/" + this.itemName(item.get()) + "_" + extension));
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + handheldEx, handheldModel)).texture("layer0", this.modLoc("item/" + location + "/" + this.itemName(item.get()) + "_" + extension + "_handheld"));
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + blockingEx, blockingModel)).texture("layer0", this.modLoc("item/" + location + "/" + this.itemName(item.get()) + "_" + extension + "_handheld"));
        ((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + "_" + extension + "_base", handheldModel)).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc(String.valueOf(item.get()) + handheldEx))))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc(String.valueOf(item.get()) + guiEx))))).perspective(ItemDisplayContext.FIXED, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc(String.valueOf(item.get()) + guiEx))))).perspective(ItemDisplayContext.GROUND, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc(String.valueOf(item.get()) + guiEx))))).end();
        ((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + "_" + extension + "_blocking", handheldModel)).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc(String.valueOf(item.get()) + blockingEx))))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc(String.valueOf(item.get()) + guiEx))))).perspective(ItemDisplayContext.FIXED, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc(String.valueOf(item.get()) + guiEx))))).perspective(ItemDisplayContext.GROUND, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc(String.valueOf(item.get()) + guiEx))))).end();
    }

    public void shieldItem(Supplier<? extends Item> item, String location) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + "_blocking", this.modLoc("item/elementus_model_shield_blocking"))).texture("layer0", this.modLoc("item/" + location + "/" + this.itemName(item.get())));
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()), this.modLoc("item/elementus_model_shield"))).texture("layer0", this.modLoc("item/" + location + "/" + this.itemName(item.get())))).override().predicate(new ResourceLocation("blocking"), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("item/" + this.itemName(item.get()) + "_blocking"))).end();
    }

    public void twoLayeredItem(String itemModel, Supplier<? extends Item> layer0, Supplier<? extends Item> layer1, String location) {
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(layer0.get()), this.mcLoc("item/" + itemModel))).texture("layer0", this.modLoc("item//" + location + "/" + this.itemName(layer0.get())))).texture("layer1", this.modLoc("item//" + location + "/" + this.itemName(layer1.get())));
    }

    public void emmisiveItemModel(String itemModel, Supplier<? extends Item> layer0, Supplier<? extends Item> layer1, String location) {
        ((ItemModelBuilder)((ItemModelBuilder)((ItemLayerModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(layer0.get()), this.mcLoc("item/" + itemModel))).customLoader(ItemLayerModelBuilder::begin)).emissive(15, 15, new int[]{1}).end()).texture("layer0", this.modLoc("item//" + location + "/" + this.itemName(layer0.get())))).texture("layer1", this.modLoc("item//" + location + "/" + this.itemName(layer1.get())));
    }

    public void armorItem(Supplier<? extends Item> item, String location) {
        String name;
        Item item2 = item.get();
        if (item2 instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item2;
            ItemModelBuilder builder = (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + location + "/" + this.itemName(item.get())));
            double index = 0.1;
            for (ResourceKey<TrimMaterial> trimMaterial : VANILLA_TRIM_MATERIALS) {
                String material = trimMaterial.m_135782_().m_135815_();
                name = this.itemName(item.get()) + "_" + material + "_trim";
                ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + location + "/" + this.itemName(item.get())))).texture("layer1", this.mcLoc("trims/items/" + armorItem.m_266204_().m_266355_() + "_trim_" + material));
                builder.override().predicate(new ResourceLocation("trim_type"), (float)index).model((ModelFile)this.getExistingFile(this.modLoc("item/" + name))).end();
                index += 0.1;
            }
        }
        if (ModChecker.aether && item.get() instanceof GlovesItem) {
            ItemModelBuilder builder = (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + location + "/" + this.itemName(item.get())));
            double index = 0.1;
            for (ResourceKey<TrimMaterial> trimMaterial : VANILLA_TRIM_MATERIALS) {
                String material = trimMaterial.m_135782_().m_135815_();
                String var10000 = this.itemName(item.get());
                name = var10000 + "_" + material + "_trim";
                ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + location + "/" + this.itemName(item.get())))).texture("layer1", "aether:trims/items/gloves_trim_" + material);
                builder.override().predicate(new ResourceLocation("trim_type"), (float)index).model((ModelFile)this.getExistingFile(this.modLoc("item/" + name))).end();
                index += 0.1;
            }
        }
    }

    public void catalystArmor(Supplier<? extends Item> item) {
        String predicate = "catalyst";
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/armor/catalyst_chestplate"))).override().predicate(this.modLoc(predicate), 0.11f).model((ModelFile)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + "_nether_star", this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/armor/catalyst_chestplate"))).texture("layer1", this.modLoc("item/armor/catalyst_nether_star"))).end().override().predicate(this.modLoc(predicate), 0.12f).model((ModelFile)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + "_ignitium_ingot", this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/armor/catalyst_chestplate"))).texture("layer1", this.modLoc("item/armor/catalyst_ignitium_ingot"))).end().override().predicate(this.modLoc(predicate), 0.13f).model((ModelFile)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + "_arcane_ingot", this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/armor/catalyst_chestplate"))).texture("layer1", this.modLoc("item/armor/catalyst_arcane_ingot"))).end().override().predicate(this.modLoc(predicate), 0.14f).model((ModelFile)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + "_heart_of_the_sea", this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/armor/catalyst_chestplate"))).texture("layer1", this.modLoc("item/armor/catalyst_heart_of_the_sea"))).end().override().predicate(this.modLoc(predicate), 0.15f).model((ModelFile)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + "_totem_of_undying", this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/armor/catalyst_chestplate"))).texture("layer1", this.modLoc("item/armor/catalyst_totem_of_undying"))).end().override().predicate(this.modLoc(predicate), 0.16f).model((ModelFile)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + "_cursium_ingot", this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/armor/catalyst_chestplate"))).texture("layer1", this.modLoc("item/armor/catalyst_cursium_ingot"))).end().override().predicate(this.modLoc(predicate), 0.17f).model((ModelFile)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + "_withered_nether_star", this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/armor/catalyst_chestplate"))).texture("layer1", this.modLoc("item/armor/catalyst_withered_nether_star"))).end();
    }

    public void blockItem(Supplier<? extends Block> block) {
        this.withExistingParent(this.blockName(block), this.texture(this.blockName(block)));
    }

    public void itemBlock(Supplier<? extends Block> block, String suffix) {
        this.withExistingParent(this.blockName(block), this.texture(this.blockName(block) + suffix));
    }

    public void itemBlockGenerated(Supplier<? extends Item> item, String location) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("block/" + location + "/" + this.itemName(item.get())));
    }

    public void fenceItem(Supplier<? extends Block> block, Supplier<? extends Block> baseBlock, String location) {
        ((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("block/fence_inventory"))).texture("texture", this.texture(this.blockName(baseBlock), location + "/"));
    }

    public void buttonItem(Supplier<? extends Block> block, Supplier<? extends Block> baseBlock, String location) {
        ((ItemModelBuilder)this.withExistingParent(this.blockName(block), this.mcLoc("block/button_inventory"))).texture("texture", this.texture(this.blockName(baseBlock), location + "/"));
    }

    public ItemModelBuilder wall(Supplier<? extends WallBlock> wall, Supplier<? extends Block> fullBlock) {
        return (ItemModelBuilder)this.wallInventory(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)((Block)wall.get()))).m_135815_(), this.texture(this.blockName(fullBlock)));
    }

    public void glovesItem(Item item, String location) {
        ItemModelBuilder builder = (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item), this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + location + this.itemName(item)));
        double index = 0.1;
        for (ResourceKey<TrimMaterial> trimMaterial : VANILLA_TRIM_MATERIALS) {
            String material = trimMaterial.m_135782_().m_135815_();
            String var10000 = this.itemName(item);
            String name = var10000 + "_" + material + "_trim";
            ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, this.mcLoc("item/generated"))).texture("layer0", this.modLoc("item/" + location + this.itemName(item)))).texture("layer1", "aether:trims/items/gloves_trim_" + material);
            builder.override().predicate(new ResourceLocation("trim_type"), (float)index).model((ModelFile)this.getExistingFile(this.modLoc("item/" + name))).end();
            index += 0.1;
        }
    }

    public void spellBookItem(Supplier<? extends Item> item) {
        String modLoc = "irons_spellbooks";
        String modelFile = "spellbook_model";
        ((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()), new ResourceLocation("generated"))).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(this.itemName(item.get()) + "_model", this.modLoc(this.itemName(item.get())))))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(this.itemName(item.get()) + "_gui", this.mcLoc("generated"))))).end();
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + "_gui", this.mcLoc("generated"))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/" + this.itemName(item.get()) + "_gui"));
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + "_model", this.modLoc(modelFile))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/" + this.itemName(item.get()) + "_model"));
    }

    public void simplySwordsItem(String material) {
        String modLoc = "simplyswords";
        String chakram = "chakram";
        String claymore = "claymore";
        String cutlass = "cutlass";
        String glaive = "glaive";
        String greataxe = "greataxe";
        String greathammer = "greathammer";
        String halberd = "halberd";
        String katana = "katana";
        String longsword = "longsword";
        String rapier = "rapier";
        String sai = "sai";
        String scythe = "scythe";
        String spear = "spear";
        String twinblade = "twinblade";
        String warglaive = "warglaive";
        ((ItemModelBuilder)this.withExistingParent(material + "_" + chakram, this.modLoc("item/" + modLoc + "/template_" + chakram))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/" + material + "/" + material + "_" + chakram));
        ((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(material + "_" + claymore, new ResourceLocation("handheld"))).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(material + "_" + claymore + "_model", this.modLoc("item/" + modLoc + "/template_" + claymore))))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(material + "_" + claymore + "_gui", this.mcLoc("generated"))))).end();
        ((ItemModelBuilder)this.withExistingParent(material + "_" + claymore + "_gui", this.mcLoc("generated"))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/" + material + "/" + material + "_" + claymore + "_gui"));
        ((ItemModelBuilder)this.withExistingParent(material + "_" + claymore + "_model", this.modLoc("item/" + modLoc + "/template_" + claymore))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/" + material + "/" + material + "_" + claymore + "_model"));
        ((ItemModelBuilder)this.withExistingParent(material + "_" + cutlass, this.mcLoc("handheld"))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/" + material + "/" + material + "_" + cutlass));
        ((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(material + "_" + glaive, new ResourceLocation("handheld"))).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(material + "_" + glaive + "_model", this.modLoc("item/" + modLoc + "/big_handheld"))))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(material + "_" + glaive + "_gui", this.mcLoc("generated"))))).end();
        ((ItemModelBuilder)this.withExistingParent(material + "_" + glaive + "_gui", this.mcLoc("generated"))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/" + material + "/" + material + "_" + glaive + "_gui"));
        ((ItemModelBuilder)this.withExistingParent(material + "_" + glaive + "_model", this.modLoc("item/" + modLoc + "/big_handheld"))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/" + material + "/" + material + "_" + glaive + "_model"));
        ((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(material + "_" + greataxe, new ResourceLocation("handheld"))).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(material + "_" + greataxe + "_model", this.modLoc("item/" + modLoc + "/big_handheld"))))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(material + "_" + greataxe + "_gui", this.mcLoc("generated"))))).end();
        ((ItemModelBuilder)this.withExistingParent(material + "_" + greataxe + "_gui", this.mcLoc("generated"))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/" + material + "/" + material + "_" + greataxe + "_gui"));
        ((ItemModelBuilder)this.withExistingParent(material + "_" + greataxe + "_model", this.modLoc("item/" + modLoc + "/big_handheld"))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/" + material + "/" + material + "_" + greataxe + "_model"));
        ((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(material + "_" + greathammer, new ResourceLocation("handheld"))).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(material + "_" + greathammer + "_model", this.modLoc("item/" + modLoc + "/template_reworked_greathammer"))))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(material + "_" + greathammer + "_gui", this.mcLoc("generated"))))).end();
        ((ItemModelBuilder)this.withExistingParent(material + "_" + greathammer + "_gui", this.mcLoc("generated"))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/" + material + "/" + material + "_" + greathammer + "_gui"));
        ((ItemModelBuilder)this.withExistingParent(material + "_" + greathammer + "_model", this.modLoc("item/" + modLoc + "/template_reworked_greathammer"))).texture("texture", this.modLoc("item/compat/" + modLoc + "/" + material + "/" + material + "_" + greathammer + "_model"));
        ((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(material + "_" + halberd, new ResourceLocation("handheld"))).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(material + "_" + halberd + "_model", this.modLoc("item/" + modLoc + "/long_handheld"))))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(material + "_" + halberd + "_gui", this.mcLoc("generated"))))).end();
        ((ItemModelBuilder)this.withExistingParent(material + "_" + halberd + "_gui", this.mcLoc("generated"))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/" + material + "/" + material + "_" + halberd + "_gui"));
        ((ItemModelBuilder)this.withExistingParent(material + "_" + halberd + "_model", this.modLoc("item/" + modLoc + "/long_handheld"))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/" + material + "/" + material + "_" + halberd + "_model"));
        ((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(material + "_" + katana, new ResourceLocation("handheld"))).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(material + "_" + katana + "_model", this.modLoc("item/" + modLoc + "/template_" + katana))))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(material + "_" + katana + "_gui", this.mcLoc("generated"))))).end();
        ((ItemModelBuilder)this.withExistingParent(material + "_" + katana + "_gui", this.mcLoc("generated"))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/" + material + "/" + material + "_" + katana + "_gui"));
        ((ItemModelBuilder)this.withExistingParent(material + "_" + katana + "_model", this.modLoc("item/" + modLoc + "/template_" + katana))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/" + material + "/" + material + "_" + katana + "_model"));
        ((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(material + "_" + longsword, new ResourceLocation("handheld"))).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(material + "_" + longsword + "_model", this.modLoc("item/" + modLoc + "/template_" + longsword))))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(material + "_" + longsword + "_gui", this.mcLoc("generated"))))).end();
        ((ItemModelBuilder)this.withExistingParent(material + "_" + longsword + "_gui", this.mcLoc("generated"))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/" + material + "/" + material + "_" + longsword + "_gui"));
        ((ItemModelBuilder)this.withExistingParent(material + "_" + longsword + "_model", this.modLoc("item/" + modLoc + "/template_" + longsword))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/" + material + "/" + material + "_" + longsword + "_model"));
        ((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(material + "_" + rapier, new ResourceLocation("handheld"))).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(material + "_" + rapier + "_model", this.modLoc("item/" + modLoc + "/template_" + longsword))))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(material + "_" + rapier + "_gui", this.mcLoc("generated"))))).end();
        ((ItemModelBuilder)this.withExistingParent(material + "_" + rapier + "_gui", this.mcLoc("generated"))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/" + material + "/" + material + "_" + rapier + "_gui"));
        ((ItemModelBuilder)this.withExistingParent(material + "_" + rapier + "_model", this.modLoc("item/" + modLoc + "/template_" + longsword))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/" + material + "/" + material + "_" + rapier + "_model"));
        ((ItemModelBuilder)this.withExistingParent(material + "_" + sai, this.mcLoc("handheld"))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/" + material + "/" + material + "_" + sai));
        ((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(material + "_" + scythe, new ResourceLocation("handheld"))).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(material + "_" + scythe + "_model", this.modLoc("item/" + modLoc + "/big_handheld"))))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(material + "_" + scythe + "_gui", this.mcLoc("generated"))))).end();
        ((ItemModelBuilder)this.withExistingParent(material + "_" + scythe + "_gui", this.mcLoc("generated"))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/" + material + "/" + material + "_" + scythe + "_gui"));
        ((ItemModelBuilder)this.withExistingParent(material + "_" + scythe + "_model", this.modLoc("item/" + modLoc + "/big_handheld"))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/" + material + "/" + material + "_" + scythe + "_model"));
        ((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(material + "_" + spear, new ResourceLocation("handheld"))).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(material + "_" + spear + "_model", this.modLoc("item/" + modLoc + "/big_handheld"))))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(material + "_" + spear + "_gui", this.mcLoc("generated"))))).end();
        ((ItemModelBuilder)this.withExistingParent(material + "_" + spear + "_gui", this.mcLoc("generated"))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/" + material + "/" + material + "_" + spear + "_gui"));
        ((ItemModelBuilder)this.withExistingParent(material + "_" + spear + "_model", this.modLoc("item/" + modLoc + "/big_handheld"))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/" + material + "/" + material + "_" + spear + "_model"));
        ((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(material + "_" + twinblade, new ResourceLocation("handheld"))).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(material + "_" + twinblade + "_model", this.modLoc("item/" + modLoc + "/template_" + twinblade))))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(material + "_" + twinblade + "_gui", this.mcLoc("generated"))))).end();
        ((ItemModelBuilder)this.withExistingParent(material + "_" + twinblade + "_gui", this.mcLoc("generated"))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/" + material + "/" + material + "_" + twinblade + "_gui"));
        ((ItemModelBuilder)this.withExistingParent(material + "_" + twinblade + "_model", this.modLoc("item/" + modLoc + "/template_" + twinblade))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/" + material + "/" + material + "_" + twinblade + "_model"));
        ((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(material + "_" + warglaive, new ResourceLocation("handheld"))).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(material + "_" + warglaive + "_model", this.modLoc("item/" + modLoc + "/template_" + warglaive))))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(material + "_" + warglaive + "_gui", this.mcLoc("generated"))))).end();
        ((ItemModelBuilder)this.withExistingParent(material + "_" + warglaive + "_gui", this.mcLoc("generated"))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/" + material + "/" + material + "_" + warglaive + "_gui"));
        ((ItemModelBuilder)this.withExistingParent(material + "_" + warglaive + "_model", this.modLoc("item/" + modLoc + "/template_" + warglaive))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/" + material + "/" + material + "_" + warglaive + "_model"));
    }

    public void sniffsWeaponsItem(String material, String type) {
        String modLoc = "sniffsweapons";
        String greatSword = "great_sword_handheld";
        String greatAxe = "great_axe_handheld";
        String greatPickaxe = "great_pickaxe_blocking_handheld";
        String naginata = "naginata_handheld";
        if (Objects.equals(type, "greatSword")) {
            ((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(material + "_great_sword", new ResourceLocation("handheld"))).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(material + "_great_sword_model", this.modLoc("item/" + modLoc + "/" + greatSword))))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(material + "_great_sword_gui", this.mcLoc("generated"))))).end();
            ((ItemModelBuilder)this.withExistingParent(material + "_great_sword_gui", this.mcLoc("generated"))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/items/" + material + "_great_sword_gui"));
            ((ItemModelBuilder)this.withExistingParent(material + "_great_sword_model", this.modLoc("item/" + modLoc + "/" + greatSword))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/items/" + material + "_great_sword_model"));
        }
        if (Objects.equals(type, "greatAxe")) {
            ((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(material + "_great_axe", new ResourceLocation("handheld"))).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(material + "_great_axe_model", this.modLoc("item/" + modLoc + "/" + greatAxe))))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(material + "_great_axe_gui", this.mcLoc("generated"))))).end();
            ((ItemModelBuilder)this.withExistingParent(material + "_great_axe_gui", this.mcLoc("generated"))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/items/" + material + "_great_axe_gui"));
            ((ItemModelBuilder)this.withExistingParent(material + "_great_axe_model", this.modLoc("item/" + modLoc + "/" + greatAxe))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/items/" + material + "_great_axe_model"));
        }
        if (Objects.equals(type, "greatPickaxe")) {
            ((ItemModelBuilder)this.withExistingParent(material + "_great_pickaxe_gui", this.mcLoc("generated"))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/items/" + material + "_great_pickaxe_gui"));
            ((ItemModelBuilder)this.withExistingParent(material + "_great_pickaxe_blocking_model", this.modLoc("item/" + modLoc + "/" + greatPickaxe))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/items/" + material + "_great_pickaxe_model"));
            ((ItemModelBuilder)this.withExistingParent(material + "_great_pickaxe_model", this.modLoc("item/" + modLoc + "/" + greatAxe))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/items/" + material + "_great_pickaxe_model"));
            ((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(material + "_great_pickaxe_blocking", new ResourceLocation("handheld"))).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(material + "_great_pickaxe_blocking_model", this.modLoc("item/" + modLoc + "/" + greatPickaxe))))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(material + "_great_pickaxe_gui", this.mcLoc("generated"))))).end();
            ((ItemModelBuilder)((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(material + "_great_pickaxe", new ResourceLocation("handheld"))).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(material + "_great_pickaxe_model", this.modLoc("item/" + modLoc + "/" + greatAxe))))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(material + "_great_pickaxe_gui", this.mcLoc("generated"))))).end()).override().predicate(new ResourceLocation("blocking"), 1.0f).model((ModelFile)this.getExistingFile(this.modLoc(material + "_great_pickaxe_blocking"))).end();
        }
        if (Objects.equals(type, "naginata")) {
            ((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(material + "_naginata", new ResourceLocation("handheld"))).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(material + "_naginata_model", this.modLoc("item/" + modLoc + "/" + naginata))))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(material + "_naginata_gui", this.mcLoc("generated"))))).end();
            ((ItemModelBuilder)this.withExistingParent(material + "_naginata_gui", this.mcLoc("generated"))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/items/" + material + "_naginata_gui"));
            ((ItemModelBuilder)this.withExistingParent(material + "_naginata_model", this.modLoc("item/" + modLoc + "/" + naginata))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/items/" + material + "_naginata_model"));
        }
        if (Objects.equals(type, "armor")) {
            ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(material + "_helm", this.mcLoc("item/generated"))).texture("layer0", modLoc + ":item/feathers")).texture("layer1", this.modLoc("item/compat/sniffsweapons/armor/" + material + "_helm"));
            ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(material + "_surcoat", this.mcLoc("item/generated"))).texture("layer0", modLoc + ":item/surcoat")).texture("layer1", this.modLoc("item/compat/sniffsweapons/armor/" + material + "_surcoat"));
            ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(material + "_horned_helm", this.mcLoc("item/generated"))).texture("layer0", modLoc + ":item/long_feathers")).texture("layer1", this.modLoc("item/compat/sniffsweapons/armor/" + material + "_horned_helm"));
            ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent("plated_" + material + "_chestplate", this.mcLoc("item/generated"))).texture("layer0", modLoc + ":item/plated_chestplate_layer")).texture("layer1", this.modLoc("item/compat/sniffsweapons/armor/plated_" + material + "_chestplate"));
            ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(material + "_kabuto", this.mcLoc("item/generated"))).texture("layer0", modLoc + ":item/mask")).texture("layer1", this.modLoc("item/compat/sniffsweapons/armor/" + material + "_kabuto"));
            ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(material + "_do", this.mcLoc("item/generated"))).texture("layer0", modLoc + ":item/do_layer")).texture("layer1", this.modLoc("item/compat/sniffsweapons/armor/" + material + "_do"));
            ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent("clothed_" + material + "_cuirass", this.mcLoc("item/generated"))).texture("layer0", modLoc + ":item/clothed_cuirass_layer")).texture("layer1", this.modLoc("item/compat/sniffsweapons/armor/clothed_" + material + "_cuirass"));
        }
    }

    public void banillaClawsItem(Supplier<? extends Item> item) {
        String modLoc = "vanilla_claws";
        String modelFile = "claws_hand";
        ((SeparateTransformsModelBuilder)((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()), new ResourceLocation("generated"))).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(this.itemName(item.get()) + "_model", this.modLoc(this.itemName(item.get())))))).perspective(ItemDisplayContext.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.withExistingParent(this.itemName(item.get()) + "_gui", this.mcLoc("generated"))))).end();
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + "_gui", this.mcLoc("generated"))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/" + this.itemName(item.get()) + "_gui"));
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item.get()) + "_model", this.modLoc("item/" + modLoc + "/" + modelFile))).texture("layer0", this.modLoc("item/compat/" + modLoc + "/" + this.itemName(item.get()) + "_model"));
    }
}

