/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.event;

import com.github.L_Ender.cataclysm.Cataclysm;
import com.github.L_Ender.cataclysm.init.ModEffect;
import com.github.L_Ender.cataclysm.init.ModParticle;
import com.github.L_Ender.cataclysm.message.MessageParticle;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.nokunami.elementus.Elementus;
import net.nokunami.elementus.ModChecker;
import net.nokunami.elementus.common.config.CatalystArmorConfig;
import net.nokunami.elementus.common.entity.ModParticleUtil;
import net.nokunami.elementus.common.entity.living.SteelGolem;
import net.nokunami.elementus.common.item.CatalystArmorItem;
import net.nokunami.elementus.common.item.ChargeBladeItem;
import net.nokunami.elementus.common.item.DiarkriteChargeBlade;
import net.nokunami.elementus.common.registry.ModBlocks;
import net.nokunami.elementus.common.registry.ModEnchantments;
import net.nokunami.elementus.common.registry.ModEntityType;
import net.nokunami.elementus.common.registry.ModItems;
import net.nokunami.elementus.common.registry.ModParticleTypes;
import net.nokunami.elementus.common.registry.ModSoundEvents;

@Mod.EventBusSubscriber(modid="elementus", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerEvents {
    private static final int parryWindow = 6;
    private static final Predicate<BlockState> PUMPKINS_PREDICATE = block -> block != null && (block.m_60713_(Blocks.f_50143_) || block.m_60713_(Blocks.f_50144_));

    @SubscribeEvent
    public void CatalystIgnitiumEffect(LivingDamageEvent event) {
        ItemStack stack = event.getEntity().m_6844_(EquipmentSlot.CHEST);
        Entity attacker = event.getSource().m_7639_();
        if (ModChecker.cataclysm && !stack.m_41619_() && event.getSource() != null && attacker != null && stack.m_41720_() == ModItems.ElementusItems.CATALYST_CHESTPLATE.get() && CatalystArmorItem.catalystActivator(stack).equals("ignitium_ingot") && attacker instanceof LivingEntity && attacker != event.getEntity() && event.getEntity().m_217043_().m_188501_() < 0.5f) {
            MobEffectInstance effectinstance1 = ((LivingEntity)attacker).m_21124_((MobEffect)ModEffect.EFFECTBLAZING_BRAND.get());
            int i = 1;
            if (effectinstance1 != null) {
                i += effectinstance1.m_19564_();
                ((LivingEntity)attacker).m_6234_((MobEffect)ModEffect.EFFECTBLAZING_BRAND.get());
            } else {
                --i;
            }
            i = Mth.m_14045_((int)i, (int)0, (int)4);
            MobEffectInstance effectinstance = new MobEffectInstance((MobEffect)ModEffect.EFFECTBLAZING_BRAND.get(), 100, i, false, false, true);
            ((LivingEntity)attacker).m_7292_(effectinstance);
            if (!attacker.m_6060_()) {
                attacker.m_20254_(5);
            }
        }
    }

    @SubscribeEvent
    public void CatalystCursiumEffect(LivingDamageEvent event) {
        ItemStack stack = event.getEntity().m_6844_(EquipmentSlot.CHEST);
        Entity attacker = event.getSource().m_7639_();
        if (ModChecker.cataclysm && !stack.m_41619_() && event.getSource() != null && attacker != null && stack.m_41720_() == ModItems.ElementusItems.CATALYST_CHESTPLATE.get() && CatalystArmorItem.catalystActivator(stack).equals("cursium_ingot")) {
            if (event.getEntity().m_21023_((MobEffect)ModEffect.EFFECTGHOST_FORM.get()) && !event.getSource().m_269533_(DamageTypeTags.f_268738_)) {
                event.setCanceled(true);
            }
            if (!stack.m_41619_() && stack.m_41720_() == ModItems.ElementusItems.CATALYST_CHESTPLATE.get()) {
                if (event.getSource().m_269533_(DamageTypeTags.f_268524_)) {
                    if ((double)event.getEntity().m_217043_().m_188501_() < CatalystArmorConfig.cursium_ProjectileDodgeChance) {
                        event.setCanceled(true);
                    }
                } else if (!event.getSource().m_269533_(DamageTypeTags.f_268738_) && (double)event.getEntity().m_217043_().m_188501_() < CatalystArmorConfig.cursium_DodgeChance) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void CatalystCursiumReviveEffect(LivingDeathEvent event) {
        ItemStack stack = event.getEntity().m_6844_(EquipmentSlot.CHEST);
        DamageSource source = event.getSource();
        if (ModChecker.cataclysm && !event.getEntity().m_9236_().f_46443_ && !stack.m_41619_() && stack.m_41720_() == ModItems.ElementusItems.CATALYST_CHESTPLATE.get() && CatalystArmorItem.catalystActivator(stack).equals("cursium_ingot") && !source.m_269533_(DamageTypeTags.f_268738_) && ServerEvents.tryCursiumPlateRebirth(event.getEntity())) {
            event.setCanceled(true);
        }
    }

    private static boolean tryCursiumPlateRebirth(LivingEntity living) {
        ItemStack chestplate = living.m_6844_(EquipmentSlot.CHEST);
        if (ModChecker.cataclysm && chestplate.m_41720_() == ModItems.ElementusItems.CATALYST_CHESTPLATE.get() && CatalystArmorItem.catalystActivator(chestplate).equals("cursium_ingot") && !living.m_21023_((MobEffect)ModEffect.EFFECTGHOST_SICKNESS.get()) && !living.m_21023_((MobEffect)ModEffect.EFFECTGHOST_FORM.get())) {
            living.m_21153_(5.0f);
            living.m_7292_(new MobEffectInstance(MobEffects.f_19607_, CatalystArmorConfig.cursium_FireResistDuration, 0));
            living.m_7292_(new MobEffectInstance((MobEffect)ModEffect.EFFECTGHOST_FORM.get(), CatalystArmorConfig.cursium_GhostFormDuration, 0));
            double d0 = living.m_20185_();
            double d1 = living.m_20186_() + (double)0.3f;
            double d2 = living.m_20189_();
            float size = 3.0f;
            for (ServerPlayer serverplayer : ((ServerLevel)living.m_9236_()).m_6907_()) {
                if (!(serverplayer.m_20238_(Vec3.m_82512_((Vec3i)living.m_20183_())) < 1024.0)) continue;
                MessageParticle particlePacket = new MessageParticle();
                for (float i = -size; i <= size; i += 1.0f) {
                    for (float j = -size; j <= size; j += 1.0f) {
                        for (float k = -size; k <= size; k += 1.0f) {
                            double d3 = (double)j + (living.m_217043_().m_188500_() - living.m_217043_().m_188500_()) * 0.5;
                            double d4 = (double)i + (living.m_217043_().m_188500_() - living.m_217043_().m_188500_()) * 0.5;
                            double d5 = (double)k + (living.m_217043_().m_188500_() - living.m_217043_().m_188500_()) * 0.5;
                            double d6 = (double)Mth.m_14116_((float)((float)(d3 * d3 + d4 * d4 + d5 * d5))) / 0.5 + living.m_217043_().m_188583_() * 0.05;
                            particlePacket.queueParticle((ParticleOptions)ModParticle.CURSED_FLAME.get(), false, d0, d1, d2, d3 / d6, d4 / d6, d5 / d6);
                            if (i == -size || i == size || j == -size || j == size) continue;
                            k += size * 2.0f - 1.0f;
                        }
                    }
                }
                Cataclysm.NETWORK_WRAPPER.send(PacketDistributor.PLAYER.with(() -> serverplayer), (Object)particlePacket);
            }
            return true;
        }
        return false;
    }

    private BlockPattern createSteelGolemFull() {
        return BlockPatternBuilder.m_61243_().m_61247_(new String[]{"~^~", "###", "~#~"}).m_61244_('^', BlockInWorld.m_61169_(PUMPKINS_PREDICATE)).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)((Block)ModBlocks.ElementusBlocks.STEEL_BLOCK.get())))).m_61244_('~', state -> state.m_61168_().m_60795_()).m_61249_();
    }

    @SubscribeEvent
    public void spawnSteelGolemEvent(BlockEvent.EntityPlaceEvent event) {
        Block block = event.getPlacedBlock().m_60734_();
        if (block instanceof CarvedPumpkinBlock) {
            BlockPos blockpos = event.getPos();
            Level level = Objects.requireNonNull(event.getEntity()).m_9236_();
            BlockPattern.BlockPatternMatch blockpattern$blockpatternmatch = this.createSteelGolemFull().m_61184_((LevelReader)level, blockpos);
            if (blockpattern$blockpatternmatch != null) {
                for (int j = 0; j < this.createSteelGolemFull().m_61203_(); ++j) {
                    for (int k = 0; k < this.createSteelGolemFull().m_61202_(); ++k) {
                        BlockInWorld blockinworld = blockpattern$blockpatternmatch.m_61229_(j, k, 0);
                        level.m_7731_(blockinworld.m_61176_(), Blocks.f_50016_.m_49966_(), 2);
                        level.m_46796_(2001, blockinworld.m_61176_(), Block.m_49956_((BlockState)blockinworld.m_61168_()));
                    }
                }
                blockpos = blockpattern$blockpatternmatch.m_61229_(1, 2, 0).m_61176_();
                SteelGolem steelgolem = (SteelGolem)((EntityType)ModEntityType.STEEL_GOLEM.get()).m_20615_(level);
                assert (steelgolem != null);
                steelgolem.setPlayerCreated(true);
                steelgolem.m_7678_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.05, (double)blockpos.m_123343_() + 0.5, 0.0f, 0.0f);
                level.m_7967_((Entity)steelgolem);
                for (ServerPlayer serverplayer1 : level.m_45976_(ServerPlayer.class, steelgolem.m_20191_().m_82400_(5.0))) {
                    CriteriaTriggers.f_10580_.m_68256_(serverplayer1, (Entity)steelgolem);
                }
                for (int i1 = 0; i1 < this.createSteelGolemFull().m_61203_(); ++i1) {
                    for (int j1 = 0; j1 < this.createSteelGolemFull().m_61202_(); ++j1) {
                        BlockInWorld blockinworld = blockpattern$blockpatternmatch.m_61229_(i1, j1, 0);
                        level.m_6289_(blockinworld.m_61176_(), Blocks.f_50016_);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void LivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.m_20193_();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            boolean startResonance;
            ItemStack stack = entity.m_6844_(slot);
            boolean emptyItem = stack.m_41619_();
            boolean currentCharge = DiarkriteChargeBlade.getCharge(stack) < DiarkriteChargeBlade.getMaxCharge(stack);
            boolean bl = startResonance = DiarkriteChargeBlade.getResonanceCharge(stack) > 0;
            if (emptyItem || !(stack.m_41720_() instanceof DiarkriteChargeBlade) || !DiarkriteChargeBlade.isEnchantedWith(stack, ModEnchantments.RESONANCE) || !(entity instanceof Player)) continue;
            Player player = (Player)entity;
            if (!currentCharge || !startResonance || player.m_6117_() || level.m_46467_() % 100L != 0L) continue;
            DiarkriteChargeBlade.setCharge(stack, 1);
            DiarkriteChargeBlade.setResonanceCharge(stack, -1);
            DiarkriteChargeBlade.setResonanceTick(stack, 2);
            ModParticleUtil.spawnParticlesOnEntity(level, (Position)entity.m_20182_(), (ParticleOptions)ParticleTypes.f_175827_, (Entity)entity, (IntProvider)UniformInt.m_146622_((int)2, (int)4));
        }
    }

    private float damageAbsorption(ItemStack stack) {
        float i0 = Math.min(DiarkriteChargeBlade.getCharge(stack), DiarkriteChargeBlade.getMaxCharge(stack));
        float i1 = DiarkriteChargeBlade.getMaxCharge(stack);
        return 1.0f - i0 / i1 * 0.5f;
    }

    @SubscribeEvent
    public void ParryEvent(LivingHurtEvent event) {
        AbstractArrow abstractarrow;
        DamageSource damageSource = event.getSource();
        LivingEntity eventEntity = event.getEntity();
        Vec3 position = eventEntity.m_20182_();
        Vec3 viewVec = eventEntity.m_20252_(1.0f);
        Vec3 vec32 = damageSource.m_7270_();
        Entity directAttacker = damageSource.m_7640_();
        Entity attacker = damageSource.m_7639_();
        boolean usingItem = eventEntity.m_6117_();
        Level level = eventEntity.m_9236_();
        float damage = event.getAmount();
        float randomFloat = 0.5f + (eventEntity.m_217043_().m_188501_() - eventEntity.m_217043_().m_188501_()) * 0.5f;
        boolean flag = false;
        if (directAttacker instanceof AbstractArrow && (abstractarrow = (AbstractArrow)directAttacker).m_36796_() > 0) {
            flag = true;
        }
        if (vec32 != null) {
            Vec3 vec31 = vec32.m_82505_(position).m_82541_();
            vec31 = new Vec3(vec31.f_82479_, 0.0, vec31.f_82481_);
            if (vec31.m_82526_(viewVec) < 0.0) {
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    LivingEntity living;
                    boolean parry;
                    ItemStack stack = eventEntity.m_6844_(slot);
                    boolean bl = parry = eventEntity.m_21252_() <= 6;
                    if (stack.m_41619_() || !(stack.m_41720_() instanceof ChargeBladeItem) || !usingItem) continue;
                    float soundVol = 1.0f;
                    SoundEvent soundEvent = DiarkriteChargeBlade.isEnchantedWith(stack, ModEnchantments.RESONANCE) ? (SoundEvent)ModSoundEvents.DIARKRITE_CHARGE_BLADE_BLOCK_RESONANCE.get() : (SoundEvent)ModSoundEvents.DIARKRITE_CHARGE_BLADE_BLOCK.get();
                    float damageAmount = 0.0f;
                    float knockback = 0.0f;
                    if (((ChargeBladeItem)stack.m_41720_()).canParry() && parry) {
                        soundEvent = DiarkriteChargeBlade.isEnchantedWith(stack, ModEnchantments.RESONANCE) ? (SoundEvent)ModSoundEvents.DIARKRITE_CHARGE_BLADE_PARRY_RESONANCE.get() : (SoundEvent)ModSoundEvents.DIARKRITE_CHARGE_BLADE_PARRY.get();
                        ParticleOptions parryParticle = DiarkriteChargeBlade.isEnchantedWith(stack, ModEnchantments.RESONANCE) ? (ParticleOptions)ModParticleTypes.PARRY_RESONANCE.get() : (ParticleOptions)ModParticleTypes.PARRY.get();
                        DiarkriteChargeBlade.parryParticle(level, eventEntity, parryParticle);
                        DiarkriteChargeBlade.setCharge(stack, 1);
                        soundVol = 1.5f;
                        damageAmount = event.getAmount();
                        knockback = 2.0f;
                        this.removeStuckEntities(event);
                        event.setCanceled(true);
                    } else if (!damageSource.m_269533_(DamageTypeTags.f_276146_) && !flag) {
                        event.setAmount(damage - damage * this.damageAbsorption(stack));
                        knockback = 1.0f;
                    } else if (stack.m_41720_() instanceof DiarkriteChargeBlade && damageSource.m_276093_(DamageTypes.f_268679_)) {
                        soundEvent = (SoundEvent)ModSoundEvents.DIARKRITE_CHARGE_BLADE_SONIC_RESONANCE.get();
                        event.setAmount(event.getAmount() * 0.8f);
                        DiarkriteChargeBlade.setCharge(stack, (int)event.getAmount() / 2);
                    }
                    level.m_6269_(null, (Entity)eventEntity, soundEvent, SoundSource.PLAYERS, soundVol, randomFloat);
                    DiarkriteChargeBlade.setCharge(stack, 1);
                    DiarkriteChargeBlade.setResonanceCharge(stack, 1);
                    DiarkriteChargeBlade.applyRecoil(directAttacker, (Entity)eventEntity, knockback, true);
                    if (directAttacker instanceof LivingEntity) {
                        living = (LivingEntity)directAttacker;
                        if (parry) {
                            DiarkriteChargeBlade.parry(level, (Player)eventEntity, living, damageAmount);
                        }
                    }
                    if (!(attacker instanceof LivingEntity)) continue;
                    living = (LivingEntity)attacker;
                    if (!DiarkriteChargeBlade.isEnchantedWith(stack, ModEnchantments.RESONANCE) || !parry) continue;
                    DiarkriteChargeBlade.parry(level, (Player)eventEntity, living, damageAmount);
                }
            }
        }
    }

    private void blockAction(LivingHurtEvent event, boolean cancelEvent, float damage, ItemStack stack, double chargeAmount) {
        event.setCanceled(cancelEvent);
        event.setAmount(damage);
        DiarkriteChargeBlade.setCharge(stack, (int)chargeAmount);
    }

    private void blockAction(LivingHurtEvent event, float damage, ItemStack stack, double chargeAmount) {
        this.blockAction(event, false, damage, stack, chargeAmount);
    }

    private void removeStuckEntities(LivingHurtEvent event) {
        Projectile projectile;
        DamageSource damageSource = event.getSource();
        LivingEntity eventEntity = event.getEntity();
        Entity directEntity = damageSource.m_7640_();
        if (directEntity instanceof Projectile && (projectile = (Projectile)directEntity) instanceof AbstractArrow) {
            eventEntity.m_21317_(eventEntity.m_21234_() - 1);
        }
        if (directEntity instanceof Bee) {
            eventEntity.m_21321_(eventEntity.m_21235_() - 1);
        }
    }

    @SubscribeEvent
    public void DeflectProjectile(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        Vec3 projectileDelta = event.getProjectile().m_20184_();
        HitResult hitResult = event.getRayTraceResult();
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult result = (EntityHitResult)hitResult;
            Elementus.LOGGER.debug("testHit1");
            Entity entity = result.m_82443_();
            if (entity instanceof LivingEntity) {
                Item item;
                LivingEntity entity2 = (LivingEntity)entity;
                Level level = entity2.m_9236_();
                float randomFloat = 0.5f + (entity2.m_217043_().m_188501_() - entity2.m_217043_().m_188501_()) * 0.5f;
                ItemStack stack = entity2.m_21211_();
                Vec3 position = entity2.m_20182_();
                Vec3 viewVec = entity2.m_20252_(1.0f);
                Vec3 vec32 = projectile.m_20182_();
                Vec3 vec31 = vec32.m_82505_(position).m_82541_();
                vec31 = new Vec3(vec31.f_82479_, 0.0, vec31.f_82481_);
                if (vec31.m_82526_(viewVec) < 0.0 && (item = entity2.m_21211_().m_41720_()) instanceof ChargeBladeItem) {
                    ChargeBladeItem bladeItem = (ChargeBladeItem)item;
                    if (entity2.m_6117_() && entity2.m_21252_() <= 6 && bladeItem.canParry() && !DiarkriteChargeBlade.isEnchantedWith(stack, ModEnchantments.RESONANCE)) {
                        Elementus.LOGGER.debug("testHit2 this deflects \"i hope\"");
                        event.setCanceled(true);
                        DiarkriteChargeBlade.parryParticleAlt(level, entity2, (ParticleOptions)ModParticleTypes.PARRY.get());
                        level.m_6269_(null, (Entity)entity2, (SoundEvent)ModSoundEvents.DIARKRITE_CHARGE_BLADE_PARRY.get(), SoundSource.PLAYERS, 1.0f, randomFloat);
                        projectile.m_20334_(-projectileDelta.f_82479_ / 2.0, -projectileDelta.f_82480_ / 2.0, -projectileDelta.f_82481_ / 2.0);
                    }
                }
            }
        }
    }

    public void steelGolemConversion(LivingConversionEvent event) {
    }
}

