/*
 * Decompiled with CFR 0.152.
 */
package net.nokunami.elementus.mixin;

import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.nokunami.elementus.common.config.CatalystArmorConfig;
import net.nokunami.elementus.common.item.CatalystArmorItem;
import net.nokunami.elementus.common.item.DiarkriteBootsItem;
import net.nokunami.elementus.common.registry.ModItems;
import net.nokunami.elementus.common.registry.ModMobEffects;
import net.nokunami.elementus.common.registry.ModSoundEvents;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    public LivingEntityMixin(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Shadow
    @Nullable
    public abstract MobEffectInstance m_21124_(MobEffect var1);

    @Shadow
    public abstract boolean m_21023_(MobEffect var1);

    @Shadow
    public abstract ItemStack m_21211_();

    @Shadow
    public abstract void m_21153_(float var1);

    @Shadow
    public abstract boolean m_21219_();

    @Shadow
    public abstract boolean m_7292_(MobEffectInstance var1);

    @Shadow
    @NotNull
    public abstract Iterable<ItemStack> m_6168_();

    @Inject(method={"checkTotemDeathProtection"}, at={@At(value="RETURN")}, cancellable=true)
    public void Elementus$catalystTotem(DamageSource damageSource, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity livingEntity;
        ItemStack chestplateItem;
        LivingEntityMixin livingEntityMixin;
        LivingEntityMixin entity = this;
        if (!damageSource.m_269533_(DamageTypeTags.f_268738_) && (livingEntityMixin = this) instanceof LivingEntity && (chestplateItem = (livingEntity = (LivingEntity)livingEntityMixin).m_6844_(EquipmentSlot.CHEST)).m_150930_((Item)ModItems.ElementusItems.CATALYST_CHESTPLATE.get()) && CatalystArmorItem.catalystActivator(chestplateItem).equals("totem_of_undying") && !livingEntity.m_21023_((MobEffect)ModMobEffects.ElementusEffects.TOTEM_COOLDOWN.get())) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverplayer = (ServerPlayer)entity;
                serverplayer.m_6278_(Stats.f_12982_.m_12902_((Object)Items.f_42747_), 1);
                CriteriaTriggers.f_10551_.m_74431_(serverplayer, chestplateItem);
            }
            this.m_21153_(1.0f);
            this.m_21219_();
            this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, CatalystArmorConfig.totem_RegenDuration, CatalystArmorConfig.totem_RegenAmp));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19617_, CatalystArmorConfig.totem_AbsorbDuration, CatalystArmorConfig.totem_AbsorbAmp));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19607_, CatalystArmorConfig.totem_FireResDuration, CatalystArmorConfig.totem_FireResAmp));
            if (CatalystArmorConfig.totem_Cooldown > 0) {
                this.m_7292_(new MobEffectInstance((MobEffect)ModMobEffects.ElementusEffects.TOTEM_COOLDOWN.get(), CatalystArmorConfig.totem_Cooldown, 0));
            }
            livingEntity.m_9236_().m_7605_((Entity)this, (byte)35);
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"calculateFallDamage"}, at={@At(value="RETURN")}, cancellable=true)
    private void Elementus$calculateFallDamage(float fallDistance, float damageMultiplier, CallbackInfoReturnable<Integer> cir) {
        MobEffectInstance beaconPower = this.m_21124_((MobEffect)ModMobEffects.ElementusEffects.BEACON_POWER.get());
        MobEffectInstance witheredBeaconPower = this.m_21124_((MobEffect)ModMobEffects.ElementusEffects.WITHERED_BEACON_POWER.get());
        float f0 = beaconPower != null ? (float)(beaconPower.m_19564_() + 1) : 0.0f;
        float f1 = witheredBeaconPower != null ? (float)(witheredBeaconPower.m_19564_() + 1) : 0.0f;
        float t2 = 0.0f;
        if (beaconPower != null) {
            t2 = beaconPower.m_19564_() + 1;
        }
        if (beaconPower != null || witheredBeaconPower != null) {
            cir.setReturnValue((Object)((int)((float)Mth.m_14167_((float)(fallDistance - 3.0f - Math.max(f0, f1))) * damageMultiplier)));
        }
    }

    @Inject(method={"getJumpBoostPower"}, at={@At(value="RETURN")}, cancellable=true)
    private void Elementus$getJumpBoostPower(CallbackInfoReturnable<Float> cir) {
        float f1;
        LivingEntity livingEntity;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof LivingEntity && DiarkriteBootsItem.SculkWalkerActivation(livingEntity = (LivingEntity)livingEntityMixin)) {
            cir.setReturnValue((Object)Float.valueOf(-1.0f));
        }
        float ori = ((Float)cir.getReturnValue()).floatValue();
        MobEffectInstance beaconPower = this.m_21124_((MobEffect)ModMobEffects.ElementusEffects.BEACON_POWER.get());
        MobEffectInstance witheredBeaconPower = this.m_21124_((MobEffect)ModMobEffects.ElementusEffects.WITHERED_BEACON_POWER.get());
        float f0 = beaconPower != null ? (float)(beaconPower.m_19564_() + 1) : ori;
        float f = f1 = witheredBeaconPower != null ? (float)(witheredBeaconPower.m_19564_() + 1) : ori;
        if (beaconPower != null || witheredBeaconPower != null) {
            cir.setReturnValue((Object)Float.valueOf(0.1f * Math.max(f0, f1)));
        }
    }

    @Inject(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;broadcastEntityEvent(Lnet/minecraft/world/entity/Entity;B)V")}, cancellable=true)
    private void Elementus$playBlockSound(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity livingEntity;
        if (this.m_21211_().m_150930_((Item)ModItems.ElementusItems.DIARKRITE_SHIELD.get())) {
            livingEntity = (LivingEntity)LivingEntity.class.cast((Object)this);
            livingEntity.m_9236_().m_5594_(null, livingEntity.m_20183_(), (SoundEvent)ModSoundEvents.DIARKRITE_SHIELD_BLOCK.get(), SoundSource.PLAYERS, 1.0f, 0.8f + this.m_9236_().f_46441_.m_188501_() * 0.4f);
            cir.cancel();
        }
        if (this.m_21211_().m_150930_((Item)ModItems.ElementusItems.ANTHEKTITE_SHIELD.get())) {
            livingEntity = (LivingEntity)LivingEntity.class.cast((Object)this);
            livingEntity.m_9236_().m_5594_(null, livingEntity.m_20183_(), (SoundEvent)ModSoundEvents.ANTHEKTITE_SHIELD_BLOCK.get(), SoundSource.PLAYERS, 1.0f, 0.8f + this.m_9236_().f_46441_.m_188501_() * 0.4f);
            cir.cancel();
        }
    }

    @Inject(method={"isPushable"}, at={@At(value="RETURN")}, cancellable=true)
    private void Elementus$isPushable(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity livingEntity;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof LivingEntity && DiarkriteBootsItem.SculkWalkerActivation(livingEntity = (LivingEntity)livingEntityMixin)) {
            cir.setReturnValue((Object)false);
        }
    }
}

