package carpetaddonsnotfound.phantomspawning;

import carpetaddonsnotfound.CarpetAddonsNotFoundSettings;
import carpetaddonsnotfound.helpers.ChunkManagerHelper;
import carpetaddonsnotfound.mixins.invokers.SpawnHelperInfoInvokerMixin;
import net.minecraft.class_1311;
import net.minecraft.class_1657;
import net.minecraft.class_1948;
import net.minecraft.class_3218;

/**
 * The phantom spawning handler for the
 * {@link carpetaddonsnotfound.CarpetAddonsNotFoundSettings#phantomsObeyHostileMobCap} rule.
 *
 * @author Gilly7CE
 * @see PhantomSpawningHandler
 */
public final class ObeyHostileMobCapHandler implements PhantomSpawningHandler {
  private PhantomSpawningHandler nextHandler = new DefaultHandler();

  /**
   * {@inheritDoc}
   */
  @Override
  public PhantomSpawningHandler setNextHandler(PhantomSpawningHandler nextHandler) {
    this.nextHandler = nextHandler;
    return this.nextHandler;
  }

  /**
   * Determines whether a phantom can spawn around the player
   *
   * @param playerEntity
   *         the player entity to conditionally spawn the phantom around
   * @param world
   *         the current minecraft world.
   *
   * @return false if the mobcap around the player entity is full and
   * {@link carpetaddonsnotfound.CarpetAddonsNotFoundSettings#phantomsObeyHostileMobCap} rule is enabled, otherwise it
   * is passed to next handler which could return true or false.
   */
  @Override
  public boolean canSpawnPhantom(class_1657 playerEntity, class_3218 world) {
    if (CarpetAddonsNotFoundSettings.phantomsObeyHostileMobCap && isMobCapFull(playerEntity)) {
      return false;
    }

    return this.nextHandler.canSpawnPhantom(playerEntity, world);
  }

  private boolean isMobCapFull(class_1657 playerEntity) {
    class_1948.class_5262 info = ChunkManagerHelper.getInfo();
    //#if MC>11701
    //$$ return !((SpawnHelperInfoInvokerMixin) info).invokeIsBelowCap(
    //$$         SpawnGroup.MONSTER
            //#if MC<12103
            //$$ , playerEntity.getChunkPos()
            //#endif
    //$$ );
    //#else
    int numberOfHostileMobs = class_1311.field_6302.method_6134() * ChunkManagerHelper.getSpawningChunkCount() / (int) Math.pow(17.0D, 2.0D);
    return info.method_27830().getInt(class_1311.field_6302) > numberOfHostileMobs;
    //#endif
  }
}
