package carpetaddonsnotfound.mixins;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

import java.util.List;
import net.minecraft.class_1511;
import net.minecraft.class_2338;
import net.minecraft.class_2876;
import net.minecraft.class_2881;
import net.minecraft.class_3218;

import static carpetaddonsnotfound.CarpetAddonsNotFoundSettings.disableEndSpikeRegen;
import static net.minecraft.class_2876.field_13095;
import static net.minecraft.class_2876.field_13098;

@Mixin(class_2881.class)
public abstract class EnderDragonFightMixin {
  @Shadow
  private class_2876 dragonSpawnState;

  @Redirect(method = "tick",
            at = @At(value = "INVOKE",
                     target = "Lnet/minecraft/entity/boss/dragon/EnderDragonSpawnState;run(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/boss/dragon/EnderDragonFight;Ljava/util/List;ILnet/minecraft/util/math/BlockPos;)V"))
  private void onEnderDragonSpawnStateRun(class_2876 instance,
                                          class_3218 serverWorld,
                                          class_2881 enderDragonFight,
                                          List<class_1511> endCrystalEntities,
                                          int tick,
                                          class_2338 blockPos) {
    // This bypasses the SUMMONING_PILLARS state
    if (disableEndSpikeRegen && this.dragonSpawnState == field_13095)
      this.dragonSpawnState = field_13098;

    this.dragonSpawnState.method_12507(serverWorld, enderDragonFight, endCrystalEntities, tick, blockPos);
  }
}
