package carpetaddonsnotfound.mixins;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

//#if MC>12101
//$$ import net.minecraft.item.ItemStack;
//$$ import net.minecraft.server.world.ServerWorld;
//$$ import java.util.function.BiConsumer;
//#else
import carpetaddonsnotfound.mixins.accessors.CreeperEntityAccessor;
import net.minecraft.class_1297;
import net.minecraft.class_1548;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2373;
import net.minecraft.class_2386;
import net.minecraft.class_2680;

import static carpetaddonsnotfound.CarpetAddonsNotFoundSettings.netherWater;

@Mixin(class_2386.class)
public abstract class IceBlockMixin extends class_2373 {
  protected IceBlockMixin(class_2251 settings) {
    super(settings);
  }

  //#if MC>12101
  //$$ @Override
  //$$ protected void onExploded(
  //$$         BlockState state,
  //$$         ServerWorld world,
  //$$         BlockPos pos,
  //$$         Explosion explosion,
  //$$         BiConsumer<ItemStack, BlockPos> stackMerger) {
  //$$   if (!canCreateNetherWater(world, explosion)) {
  //$$     super.onExploded(state, world, pos, explosion, stackMerger);
  //$$     return;
  //$$   }
  //$$
  //$$   createNetherWaterOnExplosion(world, pos);
  //$$ }
  //#else
  @Override
  public void method_9586(class_1937 world, class_2338 pos, class_1927 explosion) {
    if (!canCreateNetherWater(world, explosion))
      return;

    createNetherWaterOnExplosion(world, pos);
  }
  //#endif

  @Unique
  private boolean canCreateNetherWater(class_1937 world,
                                       class_1927 explosion) {
    return netherWater &&
           isNetherDimension(world) &&
           isExplosionCausedByChargedCreeper(explosion);
  }

  @Unique
  private boolean isNetherDimension(class_1937 world) {
    return world.method_27983() == class_1937.field_25180;
  }

  @Unique
  private boolean isExplosionCausedByChargedCreeper(class_1927 explosion) {
    return getEntityThatCausedExplosion(explosion) instanceof class_1548 creeperEntity &&
           isChargedCreeper(creeperEntity);
  }

  @Unique
  private class_1297 getEntityThatCausedExplosion(class_1927 explosion) {
    //#if MC>11904
    //$$ return explosion.getEntity();
    //#else
    return explosion.method_8347();
    //#endif
  }

  @Unique
  private boolean isChargedCreeper(class_1548 creeperEntity) {
    //#if MC>12101
    //$$ return creeperEntity.isCharged();
    //#else
    return creeperEntity.method_5841().method_12789(CreeperEntityAccessor.getCharged());
    //#endif
  }

  @Unique
  private void createNetherWaterOnExplosion(class_1937 world, class_2338 pos) {
    // Copied from the else block of the `melt` method in IceBlock
    class_2680 meltedState = getIceBlockMeltedState();
    world.method_8501(pos, meltedState);
    world.method_8492(pos,
                         meltedState.method_26204(),
                         //#if MC>12101
                         //$$ null
                         //#else
                         pos
                         //#endif
    );
  }

  @Unique
  private class_2680 getIceBlockMeltedState() {
    //#if MC>11904
    //$$ return IceBlock.getMeltedState();
    //#else
    return class_2246.field_10382.method_9564();
    //#endif
  }
}
