package carpetaddonsnotfound.mixins;

import carpetaddonsnotfound.CarpetAddonsNotFoundSettings;
import carpetaddonsnotfound.helpers.WorldHelper;
import carpetaddonsnotfound.instantmining.BlockBreakingSpeedRatioCalculator;
import carpetaddonsnotfound.mixins.accessors.EntityAccessorMixin;
import carpetaddonsnotfound.mixins.invokers.EntityInvokerMixin;
import com.llamalad7.mixinextras.sugar.Local;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1508;
import net.minecraft.class_1510;
import net.minecraft.class_1656;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

@Mixin(class_1657.class)
public abstract class PlayerEntityMixin
        extends class_1309
        implements EntityAccessorMixin, EntityInvokerMixin {
  protected PlayerEntityMixin(class_1299<? extends class_1309> entityType,
                                          class_1937 world) {
    super(entityType, world);
  }

  @Shadow
  @Final
  private class_1656 abilities;

  @Shadow
  public abstract class_3419 method_5634();

  @Unique
  private final List<class_1299<?>> excludedEntities = Arrays.asList(
          class_1299.field_6097,
          class_1299.field_6043,
          class_1299.field_28401);

  /**
   * This is adapted from the
   * <a href="https://github.com/Lunaar-SMP/lunaar-carpet-addons">lunaar carpet extensions mod</a>.
   * The mod has now been archived.
   */
  @Inject(
          method = "attack",
          at = @At(
                  value = "INVOKE",
                  target = "Lnet/minecraft/entity/Entity;handleAttack(Lnet/minecraft/entity/Entity;)Z",
                  shift = At.Shift.BY,
                  by = -2
          ),
          cancellable = true
  )
  private void creativeKill(class_1297 target, CallbackInfo ci) {
    class_1937 world = this.method_37908();
    if (!canCreativeKill(target, world)) {
      return;
    }

    instantKillTarget(target, world);
    world.method_43128(
            null,
            this.invokeGetX(),
            this.invokeGetY(),
            this.invokeGetZ(),
            class_3417.field_15016,
            this.method_5634(),
            1.0f,
            1.0f);
    ci.cancel();
  }

  /**
   * Calculates the instant mining block breaking speed ratio and applies it to the vanilla block breaking speed
   *
   * @param block
   *         the block state
   * @param cir
   *         the callback returnable, which is always set
   * @param f
   *         the vanilla block breaking speed
   */
  @Inject(
          method = "getBlockBreakingSpeed",
          at = @At(
                  value = "TAIL"
          ),
          cancellable = true)
  private void getInstantMiningBlockBreakingSpeed(class_2680 block, CallbackInfoReturnable<Float> cir, @Local float f) {
    float blockBreakingSpeedRatio =
            BlockBreakingSpeedRatioCalculator.getBlockBreakingSpeedRatio(this, block);
    cir.setReturnValue(f * blockBreakingSpeedRatio);
  }

  @Unique
  private boolean canCreativeKill(class_1297 target, class_1937 world) {
    return CarpetAddonsNotFoundSettings.creativePlayerOneHitKill
           && !WorldHelper.isClient(world)
           && this.abilities.field_7477
           && class_1301.field_6156.test(target)
           && !(excludedEntities.contains(target.method_5864()));
  }

  @Unique
  private void instantKillTarget(class_1297 target, class_1937 world) {
    if (target instanceof class_1508 enderDragonPart) {
      instantKillEnderDragon(enderDragonPart, world);
      return;
    }

    killEntity(target, world);
  }

  @Unique
  private void instantKillEnderDragon(class_1508 enderDragonPart, class_1937 world) {
    class_1510 enderDragonEntity = enderDragonPart.field_7007;
    for (class_1297 enderDragonEntityPart : enderDragonEntity.method_5690()) {
      killEntity(enderDragonEntityPart, world);
    }

    killEntity(enderDragonEntity, world);
  }

  @Unique
  private void killEntity(class_1297 entity, class_1937 world) {
    //#if MC>12101
    //$$ if (world instanceof ServerWorld serverWorld) {
    //$$   entity.kill(serverWorld);
    //$$ }
    //#else
    entity.method_5768();
    //#endif
  }
}
