package carpetaddonsnotfound.mixins;

import carpetaddonsnotfound.flowerpotrules.FlowerPotRuleManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2362;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_9062;

@Mixin(class_2362.class)
public abstract class FlowerPotBlockMixin {
  @Shadow
  @Final
  private static Map<class_2248, class_2248> CONTENT_TO_POTTED;

  @Shadow
  public abstract class_2248 getContent();

  @Inject(
          //#if MC>12004
          method = "onUseWithItem",
          //#else
          //$$ method = "onUse",
          //#endif
          at = @At(
                  value = "HEAD"
          ),
          cancellable = true
  )
  private void onUseCustom(
          //#if MC>12004
          class_1799 stack,
          //#endif
          class_2680 state,
          class_1937 world,
          class_2338 pos,
          class_1657 player,
          class_1268 hand,
          class_3965 hit,
          //#if MC>12004
          //#if MC>12101
          //$$ CallbackInfoReturnable<ActionResult> cir
          //#else
          CallbackInfoReturnable<class_9062> cir
          //#endif
          //#else
          //$$ CallbackInfoReturnable<ActionResult> cir
          //#endif
          ) {
    boolean ruleExecuted =
            FlowerPotRuleManager.executeRule(CONTENT_TO_POTTED, player, hand, world, pos, state, getContent());
    if (!ruleExecuted) {
      return;
    }
    //#if MC>12004
    //#if MC>12101
    //$$ cir.setReturnValue(ActionResult.SUCCESS);
    //#else
    cir.setReturnValue(class_9062.method_55644(world.field_9236));
    //#endif
    //#else
    //$$ cir.setReturnValue(ActionResult.success(world.isClient));
    //#endif
  }
}
