package carpetaddonsnotfound.mixins;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import java.util.function.BiConsumer;
//#else
//$$ import carpetaddonsnotfound.mixins.accessors.CreeperEntityAccessor;
//$$ import net.minecraft.block.Blocks;
//#endif
import net.minecraft.class_1297;
import net.minecraft.class_1548;
import net.minecraft.class_1799;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2373;
import net.minecraft.class_2386;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

import static carpetaddonsnotfound.CarpetAddonsNotFoundSettings.netherWater;

@Mixin(class_2386.class)
public abstract class IceBlockMixin extends class_2373 {
  protected IceBlockMixin(class_2251 settings) {
    super(settings);
  }

  //#if MC>12101
  @Override
  protected void method_55124(
          class_2680 state,
          class_3218 world,
          class_2338 pos,
          class_1927 explosion,
          BiConsumer<class_1799, class_2338> stackMerger) {
    if (!canCreateNetherWater(world, explosion)) {
      super.method_55124(state, world, pos, explosion, stackMerger);
      return;
    }

    createNetherWaterOnExplosion(world, pos);
  }
  //#else
  //$$ @Override
  //$$ public void onDestroyedByExplosion(World world, BlockPos pos, Explosion explosion) {
  //$$   if (!canCreateNetherWater(world, explosion))
  //$$     return;
  //$$
  //$$   createNetherWaterOnExplosion(world, pos);
  //$$ }
  //#endif

  @Unique
  private boolean canCreateNetherWater(class_1937 world,
                                       class_1927 explosion) {
    return netherWater &&
           isNetherDimension(world) &&
           isExplosionCausedByChargedCreeper(explosion);
  }

  @Unique
  private boolean isNetherDimension(class_1937 world) {
    return world.method_27983() == class_1937.field_25180;
  }

  @Unique
  private boolean isExplosionCausedByChargedCreeper(class_1927 explosion) {
    return getEntityThatCausedExplosion(explosion) instanceof class_1548 creeperEntity &&
           isChargedCreeper(creeperEntity);
  }

  @Unique
  private class_1297 getEntityThatCausedExplosion(class_1927 explosion) {
    //#if MC>11904
    return explosion.method_46406();
    //#else
    //$$ return explosion.getCausingEntity();
    //#endif
  }

  @Unique
  private boolean isChargedCreeper(class_1548 creeperEntity) {
    //#if MC>12101
    return creeperEntity.method_61492();
    //#else
    //$$ return creeperEntity.getDataTracker().get(CreeperEntityAccessor.getCharged());
    //#endif
  }

  @Unique
  private void createNetherWaterOnExplosion(class_1937 world, class_2338 pos) {
    // Copied from the else block of the `melt` method in IceBlock
    class_2680 meltedState = getIceBlockMeltedState();
    world.method_8501(pos, meltedState);
    world.method_8492(pos,
                         meltedState.method_26204(),
                         //#if MC>12101
                         null
                         //#else
                         //$$ pos
                         //#endif
    );
  }

  @Unique
  private class_2680 getIceBlockMeltedState() {
    //#if MC>11904
    return class_2386.method_51170();
    //#else
    //$$ return Blocks.WATER.getDefaultState();
    //#endif
  }
}
