package carpetaddonsnotfound.mixins;

import carpetaddonsnotfound.CarpetAddonsNotFoundSettings;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(class_1826.class)
public abstract class SpawnEggItemMixin {

  //#if MC>12108
  @SuppressWarnings("unchecked")
  @Redirect(method = "spawnMobEntity", at = @At(value = "INVOKE",
                                            target = "Lnet/minecraft/entity/EntityType;spawnFromItemStack" +
                                                     "(Lnet/minecraft/server/world/ServerWorld;" +
                                                     "Lnet/minecraft/item/ItemStack;" +
                                                     "Lnet/minecraft/entity/LivingEntity;" +
                                                     "Lnet/minecraft/util/math/BlockPos;" +
                                                     "Lnet/minecraft/entity/SpawnReason;ZZ)" +
                                                     "Lnet/minecraft/entity/Entity;"))
  private <T extends class_1297> T maybeDisableMobAiForSpawnMobEntity(class_1299<?> instance,
                                                                  class_3218 world,
                                                                  @Nullable class_1799 stack,
                                                                  @Nullable class_1309 spawner,
                                                                  class_2338 pos,
                                                                  class_3730 spawnReason,
                                                                  boolean alignPosition,
                                                                  boolean invertY) {
    return (T) maybeDisableMobAI(instance, world, stack, spawner, pos, spawnReason, alignPosition, invertY);
  }

  //#else
  //$$ @SuppressWarnings("unchecked")
  //$$ @Redirect(method = "useOnBlock", at = @At(value = "INVOKE",
  //$$                                           target = "Lnet/minecraft/entity/EntityType;spawnFromItemStack" +
  //$$                                                    "(Lnet/minecraft/server/world/ServerWorld;" +
  //$$                                                    "Lnet/minecraft/item/ItemStack;" +
  //$$                                                    //#if MC>12104
  //$$                                                    "Lnet/minecraft/entity/LivingEntity;" +
  //$$                                                    //#else
  //$$                                                    //$$ "Lnet/minecraft/entity/player/PlayerEntity;" +
  //$$                                                    //#endif
  //$$                                                    "Lnet/minecraft/util/math/BlockPos;" +
  //$$                                                    "Lnet/minecraft/entity/SpawnReason;ZZ)" +
  //$$                                                    "Lnet/minecraft/entity/Entity;"))
  //$$ private <T extends Entity> T maybeDisableMobAiForUseOnBlock(EntityType<?> instance,
  //$$                                                             ServerWorld world,
  //$$                                                            @Nullable ItemStack stack,
  //$$                                                             //#if MC>12104
  //$$                                                             @Nullable LivingEntity spawner,
  //$$                                                             //#else
  //$$                                                             //$$ @Nullable PlayerEntity spawner,
  //$$                                                             //#endif
  //$$                                                             BlockPos pos,
  //$$                                                             SpawnReason spawnReason,
  //$$                                                             boolean alignPosition,
  //$$                                                             boolean invertY) {
  //$$   return (T) maybeDisableMobAI(instance, world, stack, spawner, pos, spawnReason, alignPosition, invertY);
  //$$ }
  //$$
  //$$ @SuppressWarnings("unchecked")
  //$$ @Redirect(method = "use",
  //$$           at = @At(value = "INVOKE",
  //$$                    target = "Lnet/minecraft/entity/EntityType;spawnFromItemStack" +
  //$$                             "(Lnet/minecraft/server/world/ServerWorld;" +
  //$$                             "Lnet/minecraft/item/ItemStack;" +
  //$$                             //#if MC>12104
  //$$                             "Lnet/minecraft/entity/LivingEntity;" +
  //$$                             //#else
  //$$                             //$$ "Lnet/minecraft/entity/player/PlayerEntity;" +
  //$$                             //#endif
  //$$                             "Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/SpawnReason;" +
  //$$                             "ZZ)Lnet/minecraft/entity/Entity;"))
  //$$ private <T extends Entity> T maybeDisableMobAiForUse(EntityType<?> instance,
  //$$                                                      ServerWorld world,
  //$$                                                      @Nullable ItemStack stack,
  //$$                                                      //#if MC>12104
  //$$                                                      @Nullable LivingEntity spawner,
  //$$                                                      //#else
  //$$                                                      //$$ @Nullable PlayerEntity spawner,
  //$$                                                      //#endif
  //$$                                                      BlockPos pos,
  //$$                                                      SpawnReason spawnReason,
  //$$                                                      boolean alignPosition,
  //$$                                                      boolean invertY) {
  //$$   return (T) maybeDisableMobAI(instance, world, stack, spawner, pos, spawnReason, alignPosition, invertY);
  //$$ }
  //#endif

  @Unique
  private class_1297 maybeDisableMobAI(class_1299<?> instance,
                                   class_3218 world,
                                   @Nullable class_1799 stack,
                                   //#if MC>12104
                                   @Nullable class_1309 spawner,
                                   //#else
                                   //$$ @Nullable PlayerEntity spawner,
                                   //#endif
                                   class_2338 pos,
                                   class_3730 spawnReason,
                                   boolean alignPosition,
                                   boolean invertY) {
    class_1297 entity = instance.method_5894(world, stack, spawner, pos, spawnReason, alignPosition, invertY);
    if (CarpetAddonsNotFoundSettings.spawnEggsSpawnMobsWithNoAI && entity instanceof class_1308 mobEntity) {
      mobEntity.method_5977(true);
    }

    return entity;
  }
}
