package carpetaddonsnotfound.mixins;

import net.minecraft.world.gen.feature.*;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

import static net.minecraft.class_6809.field_35952;
//#else
//$$ import com.llamalad7.mixinextras.sugar.Local;
//$$ import net.minecraft.block.BlockState;
//$$ import net.minecraft.server.world.ServerWorld;
//$$ import net.minecraft.world.gen.feature.util.FeatureContext;
//$$ import net.minecraft.world.gen.stateprovider.SimpleBlockStateProvider;
//$$ import org.spongepowered.asm.mixin.injection.Inject;
//$$ import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
//#endif

import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2372;
import net.minecraft.class_2794;
import net.minecraft.class_3031;
import net.minecraft.class_3481;
import net.minecraft.class_4651;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5927;
import net.minecraft.class_5932;
import net.minecraft.class_6016;
import net.minecraft.class_6019;
import net.minecraft.class_6796;
import net.minecraft.class_6817;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

import static carpetaddonsnotfound.CarpetAddonsNotFoundSettings.replaceMyceliumWithGrass;

@Mixin(class_2372.class)
public abstract class GrassBlockMixin {
  //#if MC>11701
  @Redirect(method = "grow",
            at = @At(value = "INVOKE",
                     target = "Lnet/minecraft/world/gen/feature/PlacedFeature;generateUnregistered(" +
                              "Lnet/minecraft/world/StructureWorldAccess;" +
                              "Lnet/minecraft/world/gen/chunk/ChunkGenerator;" +
                              //#if MC>11802
                              "Lnet/minecraft/util/math/random/Random;" +
                              //#else
                              //$$ "Ljava/util/Random;" +
                              //#endif
                              "Lnet/minecraft/util/math/BlockPos;)Z"))
  private boolean maybeReplaceMyceliumBlocksWithGrass(class_6796 instance,
                                                      class_5281 structureWorldAccess,
                                                      class_2794 chunkGenerator,
                                                      //#if MC>11802
                                                      class_5819 random,
                                                      //#else
                                                      //$$ java.util.Random random,
                                                      //#endif
                                                      class_2338 blockPos) {
    // Do vanilla behaviour
    boolean generated = instance.method_39644(structureWorldAccess, chunkGenerator, random, blockPos);

    if(!generated || !replaceMyceliumWithGrass)
      return generated;

    class_5927 replaceMyceliumWithGrass = getFeatureConfig(structureWorldAccess);
    return class_3031.field_29250.method_40163(replaceMyceliumWithGrass, structureWorldAccess, chunkGenerator, random, blockPos);
  }
  //#else
  //$$ @Inject(method = "grow",
  //$$         at = @At(value = "INVOKE",
  //$$                  target = "Lnet/minecraft/server/world/ServerWorld;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;I)Z",
  //$$                  shift = At.Shift.AFTER))
  //$$ private void maybeReplaceMyceliumBlocksWithGrass(ServerWorld world,
  //$$                                                  java.util.Random random,
  //$$                                                  BlockPos pos,
  //$$                                                  BlockState state,
  //$$                                                  CallbackInfo ci) {
  //$$   if (!replaceMyceliumWithGrass)
  //$$     return;
  //$$
  //$$   VegetationPatchFeatureConfig replaceMyceliumWithGrass = getFeatureConfig();
  //$$   Feature
  //$$          .VEGETATION_PATCH
  //$$          .generate(new FeatureContext<>(world,
  //$$                                         world.getChunkManager().getChunkGenerator(),
  //$$                                         random,
  //$$                                         pos.up(),
  //$$                                         replaceMyceliumWithGrass));
  //$$ }
  //#endif

  @Unique
  private class_5927 getFeatureConfig(
          //#if MC>11701
          class_5281 structureWorldAccess
          //#endif
                                                       ) {
    return new class_5927(
            //#if MC>11701
            class_3481.field_35570, // Mycelium is the only block Mooshrooms can spawn on
            class_4651.method_38432(class_2246.field_10219),
            getPlacedFeature(structureWorldAccess),
            //#else
            //$$ null, // Mycelium is the only block Mooshrooms can spawn on
            //$$ new SimpleBlockStateProvider(Blocks.GRASS_BLOCK.getDefaultState()),
            //$$ () -> Feature.SIMPLE_BLOCK.configure(new SimpleBlockFeatureConfig(new SimpleBlockStateProvider(Blocks.GRASS.getDefaultState()))),
            //#endif
            class_5932.field_29314,
            class_6016.method_34998(1),
            0.0F,
            5,
            0.6F,
            class_6019.method_35017(1, 2),
            0.75F);
  }

  //#if MC>11701
  @Unique
  private class_6880<class_6796> getPlacedFeature(class_5281 structureWorldAccess) {
    //#if MC>12104
    //$$ return PlacedFeatures.createEntry(structureWorldAccess.getRegistryManager().getEntryOrThrow(SINGLE_PIECE_OF_GRASS));
    //#elseif MC>12101
    return class_6817.method_40369(structureWorldAccess.method_30349().method_30530(class_7924.field_41239).method_46747(field_35952));
    //#elseif MC>11802
    //$$ return PlacedFeatures.createEntry(structureWorldAccess.getRegistryManager().get(RegistryKeys.CONFIGURED_FEATURE).getEntry(SINGLE_PIECE_OF_GRASS).orElseThrow());
    //#else
    //$$ return PlacedFeatures.createEntry(SINGLE_PIECE_OF_GRASS);
    //#endif
  }
  //#endif
}
