package carpetaddonsnotfound.settings.ruleobservers;

import carpetaddonsnotfound.CarpetAddonsNotFoundSettings;
import carpetaddonsnotfound.settings.CarpetAddonsNotFoundRuleObserver;
import carpetaddonsnotfound.settings.ParsedCarpetAddonsNotFoundRule;
import java.util.Objects;
import net.minecraft.class_2168;
import net.minecraft.class_2561;

public final class MovableBlockEntitiesRuleObserver extends CarpetAddonsNotFoundRuleObserver {
  @Override
  public void ruleChanged(class_2168 source, ParsedCarpetAddonsNotFoundRule<?> changedRule, String userInput) {
    // Using a string here directly feels wrong but likelihood of renaming this rule is low
    if (!Objects.equals(changedRule.name(), "movableBlockEntities")) {
      return;
    }

    boolean ruleEnabled = (boolean) changedRule.value();
    if (ruleEnabled || !CarpetAddonsNotFoundSettings.movableSpawners) {
      return;
    }

    source.method_9226(
            //#if MC>11904
            () ->
            //#endif
            class_2561.method_30163("Warning: disabling `movableSpawners` as it requires `movableBlockEntities` to be enabled"),
    true);
    CarpetAddonsNotFoundSettings.movableSpawners = false;
  }
}