package carpetaddonsnotfound.mixins;

import carpetaddonsnotfound.helpers.ChunkManagerHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1948;
import net.minecraft.class_3215;
import net.minecraft.class_6540;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

/**
 * This is adapted from the
 * <a href="https://github.com/Lunaar-SMP/lunaar-carpet-addons">lunaar carpet extensions mod</a>.
 * The mod has been archived.
 */
@Mixin(class_3215.class)
public abstract class ServerChunkManagerMixin {
  @Redirect(
          //#if MC>12101
          method = "tickChunks(Lnet/minecraft/util/profiler/Profiler;J" +
                   //#if MC<12105
                   "Ljava/util/List;" +
                   //#endif
                   ")V",
          //#else
          //$$ method = "tickChunks()V",
          //#endif
          at = @At(
                  value = "INVOKE",
                  target = "Lnet/minecraft/world/SpawnHelper;setupSpawn(ILjava/lang/Iterable;" +
                           "Lnet/minecraft/world/SpawnHelper$ChunkSource;" +
                           //#if MC>11701
                           "Lnet/minecraft/world/SpawnDensityCapper;" +
                           //#endif
                           ")Lnet/minecraft/world/SpawnHelper$Info;"
          )
  )
  private class_1948.class_5262 infoSetter(
          int spawningChunkCount,
          Iterable<class_1297> entities,
          class_1948.class_5260 chunkSource
          //#if MC>11701
          , class_6540 densityCapper
          //#endif
                                    ) {
    class_1948.class_5262 info = class_1948.method_27815(
            spawningChunkCount,
            entities,
            chunkSource
            //#if MC>11701
            , densityCapper
            //#endif
            );
    // Need to set the info to allow it to be accessed by the ObeyHostileMobCap phantom spawning handler.
    // If we don't set this on all invocations of this method, then a null pointer exception is thrown.
    ChunkManagerHelper.setInfo(info, spawningChunkCount);
    return info;
  }
}
