package carpetaddonsnotfound.settings.ruleobservers;

import carpetaddonsnotfound.CarpetAddonsNotFoundSettings;
import carpetaddonsnotfound.CarpetAddonsNotFoundSettings.MovableBlockOptions;
import carpetaddonsnotfound.settings.CarpetAddonsNotFoundRuleObserver;
import carpetaddonsnotfound.settings.ParsedCarpetAddonsNotFoundRule;
import java.util.Objects;
import net.minecraft.class_2168;
import net.minecraft.class_2561;

import static carpetaddonsnotfound.CarpetAddonsNotFoundSettings.MovableBlockOptions;

public final class MovableEmptyEndPortalFramesRuleObserver extends CarpetAddonsNotFoundRuleObserver {
  @Override
  public void ruleChanged(class_2168 source, ParsedCarpetAddonsNotFoundRule<?> changedRule, String userInput) {
    // Using a string here directly feels wrong but likelihood of renaming this rule is low
    if (!Objects.equals(changedRule.name(), "movableEmptyEndPortalFrames")) {
      return;
    }

    boolean ruleEnabled = changedRule.value() != MovableBlockOptions.FALSE;
    if (ruleEnabled || !CarpetAddonsNotFoundSettings.unobtainableBlocksDropAsItems) {
      return;
    }

    source.method_9226(
            //#if MC>11904
            () ->
            //#endif
            class_2561.method_30163("Warning: disabling `unobtainableBlocksDropAsItems` as it requires `movableEmptyEndPortalFrames` to be enabled"),
    true);
    CarpetAddonsNotFoundSettings.unobtainableBlocksDropAsItems = false;
  }
}
