package carpetaddonsnotfound.movableblocks;

import java.util.Map;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;

public final class MovableBlockRuleHelper {
  private static final Map<class_2248, MovableBlockRule> rules = Map.ofEntries(
          Map.entry(class_2246.field_10398, new MovableEmptyEndPortalFramesRule()),
          Map.entry(class_2246.field_10260, new MovableSpawnersRule()));

  public static boolean isBlockMovable(class_2680 blockState) {
    class_2248 currentBlock = blockState.method_26204();
    MovableBlockRule ruleToUse = rules.get(currentBlock);
    if (ruleToUse == null)
      return false;

    return ruleToUse.isBlockMovable(blockState);
  }
}
