package carpetaddonsnotfound.mixins;

import carpetaddonsnotfound.movableblocks.MovableBlockRuleHelper;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2665;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_2665.class)
public abstract class PistonBlockMixin {
  /**
   * This was originally a redirect but that made the mod incompatible with the carpet-fixes mod. So instead of
   * redirecting the getHardness method, we're simply injecting the behavior before it is called.
   */
  @Inject(
          method = "isMovable",
          at = @At(
                  value = "INVOKE",
                  target = "Lnet/minecraft/block/BlockState;getHardness(Lnet/minecraft/world/BlockView;" +
                           "Lnet/minecraft/util/math/BlockPos;)F"
          ),
          cancellable = true)
  private static void isMovableEmptyEndPortalFrame(class_2680 state,
                                                   class_1937 world,
                                                   class_2338 pos,
                                                   class_2350 direction,
                                                   boolean canBreak,
                                                   class_2350 pistonDir,
                                                   CallbackInfoReturnable<Boolean> cir) {
    // if this is false it just means to use the default MC behaviour
    boolean isMovable = MovableBlockRuleHelper.isBlockMovable(state);
    if (isMovable) {
      cir.setReturnValue(true);
    }
  }
}
