package carpetaddonsnotfound.dispenser.behaviors;

import carpetaddonsnotfound.dispenser.DispenserItemUsageContext;
import carpetaddonsnotfound.helpers.BlockPointerHelper;
import carpetaddonsnotfound.helpers.EndPortalFrameHelper;
import net.minecraft.class_1777;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2969;
import net.minecraft.class_3218;
import net.minecraft.class_3965;

public final class PlaceEyesOfEnderDispenserBehavior extends class_2969 {
  @Override
  protected class_1799 method_10135(class_2342 pointer, class_1799 stack) {
    this.method_27955(true);
    class_1792 item = stack.method_7909();
    class_3218 world = BlockPointerHelper.getServerWorld(pointer);
    class_2350 dispenserFacing = BlockPointerHelper.getBlockState(pointer).method_11654(class_2315.field_10918);
    class_2338 frontBlockPos = BlockPointerHelper.getBlockPos(pointer).method_10093(BlockPointerHelper.getBlockState(pointer)
                                                                                              .method_11654(class_2315.field_10918));
    class_2680 frontBlockState = world.method_8320(frontBlockPos);
    class_2248 frontBlock = frontBlockState.method_26204();

    if (!(item instanceof class_1777 enderEyeItem)
        || frontBlock != class_2246.field_10398
        || EndPortalFrameHelper.hasEyeOfEnder(frontBlockState)) {
      this.method_27955(false);
      return stack;
    }

    class_3965 hitResult = new class_3965(
            class_243.method_24953(frontBlockPos),
            dispenserFacing.method_10153(),
            frontBlockPos,
            false);
    DispenserItemUsageContext context = new DispenserItemUsageContext(world, stack, hitResult);
    EndPortalFrameHelper.setFullEndPortalFrameState(enderEyeItem, context);
    return stack;
  }
}
