package carpetaddonsnotfound.mixins;

import carpetaddonsnotfound.CarpetAddonsNotFoundSettings;
import carpetaddonsnotfound.helpers.SpawnEntryHelper;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1937;
import net.minecraft.class_1948;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_3218;
import net.minecraft.class_5138;
import net.minecraft.class_5483;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1948.class)
public abstract class SpawnHelperMixin {
  @Inject(method = "isAcceptableSpawnPosition", at = @At("HEAD"), cancellable = true)
  private static void isAcceptableSpawnPosition(class_3218 world, class_2791 chunk, class_2338.class_2339 pos,
                                                double squaredDistance, CallbackInfoReturnable<Boolean> cir) {
    var dimensionId = world.method_27983().method_29177();
    if ((CarpetAddonsNotFoundSettings.disableMobSpawningInOverworld && dimensionId == class_1937.field_25179.method_29177()) ||
        (CarpetAddonsNotFoundSettings.disableMobSpawningInNether && dimensionId == class_1937.field_25180.method_29177()) ||
        (CarpetAddonsNotFoundSettings.disableMobSpawningInEnd && dimensionId == class_1937.field_25181.method_29177())) {
      cir.setReturnValue(false);
    }
  }

  @Inject(method = "canSpawn(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/SpawnGroup;" +
                   "Lnet/minecraft/world/gen/StructureAccessor;Lnet/minecraft/world/gen/chunk/ChunkGenerator;" +
                   "Lnet/minecraft/world/biome/SpawnSettings$SpawnEntry;Lnet/minecraft/util/math/BlockPos$Mutable;D)Z",
          at = @At("HEAD"), cancellable = true)
  private static void onCanSpawn(final class_3218 world, final class_1311 group,
                                 final class_5138 structureAccessor, final class_2794 chunkGenerator,
                                 final class_5483.class_1964 spawnEntry, final class_2338.class_2339 pos,
                                 final double squaredDistance, final CallbackInfoReturnable<Boolean> cir) {
    if (CarpetAddonsNotFoundSettings.endermenSpawnOnlyInTheEnd &&
        SpawnEntryHelper.getEntityType(spawnEntry) == class_1299.field_6091 &&
        world.method_27983().method_29177() != class_1937.field_25181.method_29177()) {
      cir.setReturnValue(false);
    }
  }
}
