package carpetaddonsnotfound.mixins;

import carpetaddonsnotfound.CarpetAddonsNotFoundSettings;
import carpetaddonsnotfound.interfaces.WorldAccessor;
//#if MC<=11802
import carpetaddonsnotfound.mixins.invokers.LivingEntityInvokerMixin;
//#endif
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin implements WorldAccessor {
  @Unique
  private class_1937 world;

  @Override
  public class_1937 getWorld_CarpetAddonsNotFound() {
    return world;
  }

  @Inject(method = "<init>",
          at = @At("TAIL"))
  private void init(
          class_1299<? extends class_1309> entityType,
          class_1937 world,
          CallbackInfo ci) {
    this.world = world;
  }

  @Redirect(
          //#if MC>12103
          //$$ method = "dropExperience",
          //#else
          method = "dropXp",
          //#endif
          at = @At(
                  value = "INVOKE",
                  //#if MC>12103
                  //$$ target = "Lnet/minecraft/entity/LivingEntity;getExperienceToDrop(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/Entity;)I"
                  //#elseif MC>12006
                  //$$ target = "Lnet/minecraft/entity/LivingEntity;getXpToDrop(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/Entity;)I"
                  //#elseif MC>11802
                  //$$ target = "Lnet/minecraft/entity/LivingEntity;getXpToDrop()I"
                  //#else
                  target = "Lnet/minecraft/entity/LivingEntity;getXpToDrop(Lnet/minecraft/entity/player/PlayerEntity;)I"
                  //#endif
                  ))
  private int onDropXp(
          //#if MC>12006
          //$$ LivingEntity instance,
          //$$ ServerWorld world,
          //$$ Entity attacker
          //#elseif MC>11802
          //$$ LivingEntity instance
          //#else
          class_1309 instance,
          class_1657 attackingPlayer
          //#endif
                      ) {
    if (!CarpetAddonsNotFoundSettings.dropAllXpOnPlayerDeath ||
        !((class_1309) instance instanceof class_1657 player)) {
      //#if MC>12103
      //$$ return instance.getExperienceToDrop(world, attacker);
      //#elseif MC>12006
      //$$ return instance.getXpToDrop(world, attacker);
      //#elseif MC>11802
      //$$ return instance.getXpToDrop();
      //#else
      return ((LivingEntityInvokerMixin) instance).invokeGetXpToDrop(attackingPlayer);
      //#endif
    }

    double totalExperience = calculateTotalExperience(player);
    return (int)Math.ceil(totalExperience);
  }

  // This exists because just using the totalExperience field doesn't work if levels have been set separately to xp points
  @Unique
  private double calculateTotalExperience(class_1657 player) {
    double xpLevel = player.field_7520 + player.field_7510;
    if (xpLevel < 17) {
      return Math.pow(xpLevel, 2) + 6 * xpLevel;
    }

    if (xpLevel < 32) {
      return 2.5 * Math.pow(xpLevel, 2) - 40.5 * xpLevel + 360;
    }

    return 4.5 * Math.pow(xpLevel, 2) - 162.5 * xpLevel + 2220;
  }
}
