package carpetaddonsnotfound.mixins;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

import static carpetaddonsnotfound.CarpetAddonsNotFoundSettings.disableSpidersClimbingWalls;

import net.minecraft.class_1628;

@Mixin(class_1628.class)
public abstract class SpiderEntityMixin {
  @ModifyVariable(method = "setClimbingWall",
                  at = @At("HEAD"),
                  argsOnly = true)
  private boolean modifyClimbingBoolean(boolean climbing) {
    if (disableSpidersClimbingWalls)
      return false;

    return climbing;
  }
}
