/*
 * Decompiled with CFR 0.152.
 */
package carpetaddonsnotfound.settings;

import carpet.CarpetServer;
import carpet.settings.Condition;
import carpet.settings.ParsedRule;
import carpet.settings.Rule;
import carpet.settings.SettingsManager;
import carpet.settings.Validator;
import carpetaddonsnotfound.settings.CarpetAddonsNotFoundRule;
import carpetaddonsnotfound.settings.CarpetAddonsNotFoundRuleObserver;
import carpetaddonsnotfound.settings.CarpetAddonsNotFoundRuleValidator;
import carpetaddonsnotfound.settings.CarpetAddonsNotFoundTranslations;
import carpetaddonsnotfound.settings.ParsedCarpetAddonsNotFoundRule;
import carpetaddonsnotfound.settings.ruleobservers.MovableBlockEntitiesRuleObserver;
import carpetaddonsnotfound.settings.ruleobservers.MovableEmptyEndPortalFramesRuleObserver;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;

public final class CarpetAddonsNotFoundRuleRegistrar {
    private static boolean hasRegistered = false;
    private static final List<CarpetAddonsNotFoundRuleObserver> ruleObservers = new ArrayList<MovableEmptyEndPortalFramesRuleObserver>(List.of(new MovableBlockEntitiesRuleObserver(), new MovableEmptyEndPortalFramesRuleObserver()));
    private final SettingsManager settingsManager;
    private final List<ParsedCarpetAddonsNotFoundRule<?>> rules = Lists.newArrayList();

    private CarpetAddonsNotFoundRuleRegistrar(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public static void register(Class<?> settingsClass) {
        if (hasRegistered) {
            throw new IllegalStateException("Already registered");
        }
        CarpetAddonsNotFoundRuleRegistrar registrar = new CarpetAddonsNotFoundRuleRegistrar(CarpetServer.settingsManager);
        registrar.registerObservers();
        registrar.parseSettingsClass(settingsClass);
        registrar.registerToCarpet();
        hasRegistered = true;
    }

    private static Class<? extends CarpetAddonsNotFoundRuleValidator<?>>[] extractValidators(CarpetAddonsNotFoundRule rule) {
        ArrayList validators = Lists.newArrayList((Object[])rule.validators());
        return validators.toArray(new Class[0]);
    }

    private void registerObservers() {
        for (CarpetAddonsNotFoundRuleObserver carpetAddonsNotFoundRuleObserver : ruleObservers) {
            SettingsManager.addGlobalRuleObserver((TriConsumer)carpetAddonsNotFoundRuleObserver);
        }
    }

    private void parseSettingsClass(Class<?> settingsClass) {
        for (Field field : settingsClass.getDeclaredFields()) {
            CarpetAddonsNotFoundRule rule = field.getAnnotation(CarpetAddonsNotFoundRule.class);
            if (rule == null) continue;
            this.parseRule(field, rule);
        }
    }

    private void parseRule(final Field field, final CarpetAddonsNotFoundRule rule) {
        ParsedRule carpetRule;
        final Class[] validators = CarpetAddonsNotFoundRuleRegistrar.extractValidators(rule);
        ArrayList<String> categories = new ArrayList<String>(Arrays.asList(rule.categories()));
        categories.add("carpet-addons-not-found");
        final String[] categoriesArray = categories.toArray(new String[0]);
        Rule cmRule = new Rule(){
            private final String basedKey = "carpet.rule." + this.name() + ".";

            @Nullable
            private String tr(String key) {
                return CarpetAddonsNotFoundTranslations.getTranslationString("en_us", this.basedKey + key);
            }

            public String desc() {
                String desc = this.tr("desc");
                return desc != null ? desc : "";
            }

            public String[] extra() {
                String message;
                ArrayList extraMessages = Lists.newArrayList();
                int i = 0;
                while ((message = this.tr("extra." + i)) != null) {
                    extraMessages.add(message);
                    ++i;
                }
                return extraMessages.toArray(new String[0]);
            }

            public String name() {
                return field.getName();
            }

            public String[] category() {
                return categoriesArray;
            }

            public String[] options() {
                return rule.options();
            }

            public boolean strict() {
                return rule.strict();
            }

            public Class<? extends Validator<?>>[] validate() {
                return validators;
            }

            public Class<? extends Annotation> annotationType() {
                return rule.annotationType();
            }

            public String appSource() {
                return "";
            }

            public Class<? extends Condition>[] condition() {
                return new Class[0];
            }
        };
        try {
            Class<?> parsedRuleClass = Class.forName("carpet.settings.ParsedRule");
            Constructor constructor = Arrays.stream(parsedRuleClass.getDeclaredConstructors()).filter(ctr -> ctr.getParameterTypes().length == 3).filter(ctr -> ctr.getParameterTypes()[0] == Field.class).filter(ctr -> ctr.getParameterTypes()[1].isAssignableFrom(Rule.class)).filter(ctr -> ctr.getParameterTypes()[2] == SettingsManager.class).findFirst().orElseThrow(() -> new NoSuchMethodException("Failed to get matched ParsedRule constructor"));
            constructor.setAccessible(true);
            Object carpetRuleInstance = constructor.newInstance(field, cmRule, this.settingsManager);
            if (!(carpetRuleInstance instanceof ParsedRule)) {
                throw new ClassCastException("Failed to cast to ParsedRule.");
            }
            ParsedRule carpetRuleInstance2 = (ParsedRule)carpetRuleInstance;
            carpetRule = carpetRuleInstance2;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException("Reflection error: " + e.getMessage(), e);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
            throw new RuntimeException("Instantiation error: " + e.getMessage(), e);
        }
        this.rules.add(new ParsedCarpetAddonsNotFoundRule(carpetRule));
    }

    private void registerToCarpet() {
        for (ParsedCarpetAddonsNotFoundRule<?> rule : this.rules) {
            try {
                Field rulesField = this.settingsManager.getClass().getDeclaredField("rules");
                rulesField.setAccessible(true);
                Map parsedRules = (Map)rulesField.get(this.settingsManager);
                parsedRules.put(rule.name(), rule.getCarpetRule());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

