package carpetaddonsnotfound.helpers;

import net.minecraft.class_1777;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2333;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public final class EndPortalFrameHelper {
  /**
   * Checks if the block state has an eye of ender
   *
   * @param blockState
   *         the block state to check
   *
   * @author Gilly7CE
   */
  public static boolean hasEyeOfEnder(class_2680 blockState) {
    return blockState.method_11654(class_2333.field_10958);
  }

  /**
   * Sets an end portal frame blocks state to full
   *
   * @param item
   *         the ender eye item
   * @param context
   *         the item usage context
   *
   * @author Gilly7CE
   */
  public static void setFullEndPortalFrameState(class_1777 item,
                                                class_1838 context) {
    item.method_7884(context);
  }

  /**
   * Sets an end portal frame blocks state to empty and breaks any connecting portals
   *
   * @param world
   *         the current world
   * @param blockState
   *         the current block state
   * @param pos
   *         the current block position
   *
   * @author serz
   */
  public static void setEmptyEndPortalFrameState(class_1937 world, class_2680 blockState, class_2338 pos) {
    class_2680 newState = blockState.method_11657(class_2333.field_10958, false);
    world.method_8501(pos, newState);
    //remove portal this frame used to create
    removePortal(world, pos.method_10079(blockState.method_11654(class_2333.field_10954), 1));
  }

  /**
   * Recursive method to remove connecting portal blocks, if current block is an end portal.
   *
   * @param world
   *         the current world
   * @param pos
   *         the current block position
   *
   * @author serz
   */
  private static void removePortal(class_1937 world, class_2338 pos) {
    if (world.method_8320(pos).method_26204() != class_2246.field_10027) {
      return;
    }

    world.method_8501(pos, class_2246.field_10124.method_9564());
    removePortal(world, pos.method_10095());
    removePortal(world, pos.method_10067());
    removePortal(world, pos.method_10072());
    removePortal(world, pos.method_10078());
  }
}
