package carpetaddonsnotfound.mixins;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

import static carpetaddonsnotfound.CarpetAddonsNotFoundSettings.stonecuttersDoDamage;

import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3718;
import net.minecraft.class_4970;

@Mixin(class_3718.class)
public abstract class StonecutterBlockMixin extends class_2248 {
  StonecutterBlockMixin(class_4970.class_2251 settings) {
    super(settings);
  }

  @Override
  public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
    if (world.method_8608() || !world.method_8479(pos) || !stonecuttersCanDealDamage()) {
      return;
    }

    if (stonecuttersCanHeal() && entity instanceof class_1309 livingEntity) {
      livingEntity.method_6025(-stonecuttersDoDamage);
      return;
    }

    //#if MC>11802
    //$$ RegistryEntry<DamageType> type = getDamageTypeRegistryEntry(world);
    //#if MC>12101
    //$$ if (!(world instanceof ServerWorld serverWorld)) {
    //$$   return;
    //$$ }
    //#endif
    //$$
    //$$ entity.damage(
            //#if MC>12101
            //$$ serverWorld,
            //#endif
    //$$         new DamageSource(type, new Vec3d(pos.getX(), pos.getY(), pos.getZ())),
    //$$         stonecuttersDoDamage);
    //#else
    entity.method_5643(class_1282.field_5869, stonecuttersDoDamage);
    //#endif
  }

  @Unique
  private boolean stonecuttersCanDealDamage() {
    //#if MC>11802
    //$$ return stonecuttersDoDamage != 0.0f;
    //#else
    return stonecuttersDoDamage != 0;
    //#endif
  }

  @Unique
  private boolean stonecuttersCanHeal() {
    //#if MC>11802
    //$$ return stonecuttersDoDamage < 0.0f;
    //#else
    return stonecuttersDoDamage < 0;
    //#endif
  }

  //#if MC>11802
  //$$ @Unique
  //$$ private RegistryEntry<DamageType> getDamageTypeRegistryEntry(World world) {
  //$$   DynamicRegistryManager registryManager = world.getRegistryManager();
    //#if MC>12101
    //$$ Registry<DamageType> damageTypeRegistry = registryManager.getOrThrow(RegistryKeys.DAMAGE_TYPE);
    //$$ return damageTypeRegistry.getEntry(damageTypeRegistry.get(DamageTypes.GENERIC));
    //#else
    //$$ return registryManager.get(RegistryKeys.DAMAGE_TYPE).getEntry(DamageTypes.GENERIC).orElseThrow();
    //#endif
  //$$ }
  //#endif
}
