package carpetaddonsnotfound.flowerpotrules;

import carpetaddonsnotfound.CarpetAddonsNotFoundSettings;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class FlowerPotRuleManager {
  public static boolean executeRule(Map<class_2248, class_2248> contentToPotted,
                                    class_1657 player,
                                    class_1268 hand,
                                    class_1937 world,
                                    class_2338 blockPos,
                                    class_2680 blockState,

                                    class_2248 currentContent) {
    if (CarpetAddonsNotFoundSettings.replaceFlowersInPots) {
      return ReplaceFlowersInPotsRule.execute(contentToPotted, player, hand, world, blockPos, currentContent);
    }

    if (CarpetAddonsNotFoundSettings.alwaysPickFlowersFromPots) {
      return AlwaysPickFlowersFromPotsRule.execute(blockState, world, blockPos, player);
    }

    return false;
  }
}
