package carpetaddonsnotfound.unobtainableblocks;

import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2669;

public final class UnobtainableBlockProcessor {
  public static @Nullable List<class_1799> getItemStacks(class_2669 pistonBlockEntity) {
    List<class_1799> itemStackList = new ArrayList<>();
    for (UnobtainableBlockRule unobtainableBlockRule : UnobtainableBlockRule.values()) {
      if (!unobtainableBlockRule.canDropAsItem(pistonBlockEntity))
        continue;

      itemStackList.addAll(unobtainableBlockRule.getDroppedStacks(pistonBlockEntity));
      unobtainableBlockRule.maybeDestroyBlockBelow(pistonBlockEntity);
    }

    if (itemStackList.isEmpty())
      return null;

    return itemStackList;
  }
}
