/*
 * Decompiled with CFR 0.152.
 */
package carpetaddonsnotfound.settings;

import carpet.CarpetServer;
import carpet.api.settings.CarpetRule;
import carpet.api.settings.SettingsManager;
import carpetaddonsnotfound.settings.CarpetAddonsNotFoundRule;
import carpetaddonsnotfound.settings.CarpetAddonsNotFoundRuleObserver;
import carpetaddonsnotfound.settings.CarpetAddonsNotFoundRuleValidator;
import carpetaddonsnotfound.settings.ParsedCarpetAddonsNotFoundRule;
import carpetaddonsnotfound.settings.ruleobservers.MovableBlockEntitiesRuleObserver;
import carpetaddonsnotfound.settings.ruleobservers.MovableEmptyEndPortalFramesRuleObserver;
import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class CarpetAddonsNotFoundRuleRegistrar {
    private static boolean hasRegistered = false;
    private static final List<CarpetAddonsNotFoundRuleObserver> ruleObservers = new ArrayList<MovableEmptyEndPortalFramesRuleObserver>(List.of(new MovableBlockEntitiesRuleObserver(), new MovableEmptyEndPortalFramesRuleObserver()));
    private final SettingsManager settingsManager;
    private final List<ParsedCarpetAddonsNotFoundRule<?>> rules = Lists.newArrayList();

    private CarpetAddonsNotFoundRuleRegistrar(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public static void register(Class<?> settingsClass) {
        if (hasRegistered) {
            throw new IllegalStateException("Already registered");
        }
        CarpetAddonsNotFoundRuleRegistrar registrar = new CarpetAddonsNotFoundRuleRegistrar((SettingsManager)CarpetServer.settingsManager);
        registrar.registerObservers();
        registrar.parseSettingsClass(settingsClass);
        registrar.registerToCarpet();
        hasRegistered = true;
    }

    private static Class<? extends CarpetAddonsNotFoundRuleValidator<?>>[] extractValidators(CarpetAddonsNotFoundRule rule) {
        ArrayList validators = Lists.newArrayList((Object[])rule.validators());
        return validators.toArray(new Class[0]);
    }

    private void registerObservers() {
        for (CarpetAddonsNotFoundRuleObserver carpetAddonsNotFoundRuleObserver : ruleObservers) {
            SettingsManager.registerGlobalRuleObserver((SettingsManager.RuleObserver)carpetAddonsNotFoundRuleObserver);
        }
    }

    private void parseSettingsClass(Class<?> settingsClass) {
        for (Field field : settingsClass.getDeclaredFields()) {
            CarpetAddonsNotFoundRule rule = field.getAnnotation(CarpetAddonsNotFoundRule.class);
            if (rule == null) continue;
            this.parseRule(field, rule);
        }
    }

    private void parseRule(Field field, CarpetAddonsNotFoundRule rule) {
        CarpetRule carpetRule;
        Class<? extends CarpetAddonsNotFoundRuleValidator<?>>[] validators = CarpetAddonsNotFoundRuleRegistrar.extractValidators(rule);
        ArrayList<String> categories = new ArrayList<String>(Arrays.asList(rule.categories()));
        categories.add("carpet-addons-not-found");
        String[] categoriesArray = categories.toArray(new String[0]);
        try {
            Class<?> ruleAnnotationClass = Class.forName("carpet.settings.ParsedRule$RuleAnnotation");
            Constructor<?> ctr1 = ruleAnnotationClass.getDeclaredConstructors()[0];
            ctr1.setAccessible(true);
            Object ruleAnnotation = ctr1.newInstance(false, null, null, null, categoriesArray, rule.options(), rule.strict(), "", validators);
            Class<?> parsedRuleClass = Class.forName("carpet.settings.ParsedRule");
            Constructor ctr2 = Arrays.stream(parsedRuleClass.getDeclaredConstructors()).filter(ctr -> ctr.getParameterTypes().length == 3).filter(ctr -> ctr.getParameterTypes()[0] == Field.class).filter(ctr -> ctr.getParameterTypes()[1].isAssignableFrom(ruleAnnotationClass)).filter(ctr -> ctr.getParameterTypes()[2] == SettingsManager.class).findFirst().orElseThrow(() -> new NoSuchMethodException("Failed to get matched ParsedRule constructor"));
            ctr2.setAccessible(true);
            Object carpetRuleInstance = ctr2.newInstance(field, ruleAnnotation, this.settingsManager);
            if (!(carpetRuleInstance instanceof CarpetRule)) {
                throw new ClassCastException("Failed to cast to CarpetRule.");
            }
            CarpetRule carpetRuleInstance2 = (CarpetRule)carpetRuleInstance;
            carpetRule = carpetRuleInstance2;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException("Reflection error: " + e.getMessage(), e);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
            throw new RuntimeException("Instantiation error: " + e.getMessage(), e);
        }
        this.rules.add(new ParsedCarpetAddonsNotFoundRule(carpetRule));
    }

    private void registerToCarpet() {
        for (ParsedCarpetAddonsNotFoundRule<?> rule : this.rules) {
            this.settingsManager.addCarpetRule(rule.getCarpetRule());
        }
    }
}

