/*
 * Decompiled with CFR 0.152.
 */
package carpetaddonsnotfound.settings;

import carpetaddonsnotfound.CarpetAddonsNotFoundServer;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.io.IOUtils;

public final class CarpetAddonsNotFoundTranslations {
    public static final String DEFAULT_LANGUAGE = "en_us";
    private static final String RESOURCE_DIR = "assets/carpet-addons-not-found/lang";
    private static final Map<String, Map<String, String>> translationStorage = Maps.newLinkedHashMap();
    private static final String[] LANGUAGES = List.of("en_us").toArray(new String[0]);

    public static void loadTranslations() {
        for (String language : LANGUAGES) {
            translationStorage.put(language, CarpetAddonsNotFoundTranslations.loadTranslationFile(language));
        }
    }

    public static String getTranslationString(String lang, String key) {
        return CarpetAddonsNotFoundTranslations.getTranslations(lang.toLowerCase()).get(key);
    }

    private static Map<String, String> getTranslations(String lang) {
        return translationStorage.getOrDefault(lang, Collections.emptyMap());
    }

    private static Map<String, String> loadTranslationFile(String language) {
        try {
            String fileContent = CarpetAddonsNotFoundTranslations.readResourceFileAsString(String.format("%s/%s.json", RESOURCE_DIR, language));
            return (Map)new Gson().fromJson(fileContent, TranslationMapping.class);
        }
        catch (Exception e) {
            String message = "Failed to load translation of language " + language;
            CarpetAddonsNotFoundServer.LOG.error(message, (Throwable)e);
            if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
                throw new RuntimeException(message, e);
            }
            return Collections.emptyMap();
        }
    }

    private static String readResourceFileAsString(String path) throws IOException {
        InputStream inputStream = CarpetAddonsNotFoundTranslations.class.getClassLoader().getResourceAsStream(path);
        if (inputStream == null) {
            throw new IOException("Null input stream from path " + path);
        }
        return IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
    }

    private static class TranslationMapping
    extends LinkedHashMap<String, String> {
        private TranslationMapping() {
        }
    }
}

