package carpetaddonsnotfound.mixins;

import carpetaddonsnotfound.CarpetAddonsNotFoundSettings;
import carpetaddonsnotfound.helpers.EndPortalFrameHelper;
import net.minecraft.class_1269;
import net.minecraft.class_1777;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2333;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.item.*;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1777.class)
public abstract class EnderEyeItemMixin extends class_1792 {
  protected EnderEyeItemMixin(class_1793 settings) {
    super(settings);
  }

  @Inject(method = "useOnBlock", at = @At("HEAD"), cancellable = true)
  private void useOnBlockDropEyesOfEnder(class_1838 context, CallbackInfoReturnable<class_1269> cir) {
    class_1937 world = context.method_8045();
    class_2338 blockPos = context.method_8037();
    class_2680 blockState = world.method_8320(blockPos);
    if (!CarpetAddonsNotFoundSettings.dropEyesOfEnderFromEndPortalFrame ||
        !blockState.method_27852((class_2246.field_10398)) ||
        !blockState.method_11654(class_2333.field_10958)) {
      return;
    }

    EndPortalFrameHelper.setEmptyEndPortalFrameState(world, blockState, blockPos);
    class_2248.method_9577(world, blockPos.method_10084(), new class_1799(class_1802.field_8449, 1));
    cir.setReturnValue(GetSuccessAccessResult(world));
  }

  @Unique
  private class_1269 GetSuccessAccessResult(class_1937 world) {
    //#if MC>12101
    return class_1269.field_5812;
    //#else
    //$$ return ActionResult.success(world.isClient);
    //#endif
  }
}
