package carpetaddonsnotfound.dispenser.behaviors;

import carpetaddonsnotfound.helpers.BlockPointerHelper;
import carpetaddonsnotfound.helpers.EndPortalFrameHelper;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2601;
import net.minecraft.class_2680;
import net.minecraft.class_2969;
import net.minecraft.class_3218;

public final class RemoveEyesOfEnderDispenserBehavior extends class_2969 {
  @Override
  protected class_1799 method_10135(class_2342 pointer, class_1799 stack) {
    this.method_27955(true);
    class_3218 world = BlockPointerHelper.getServerWorld(pointer);
    class_2338 frontBlockPos = BlockPointerHelper.getBlockPos(pointer).method_10093(BlockPointerHelper.getBlockState(pointer)
                                                                                              .method_11654(class_2315.field_10918));
    class_2680 frontBlockState = world.method_8320(frontBlockPos);
    class_2248 frontBlock = frontBlockState.method_26204();

    if (frontBlock != class_2246.field_10398
        || !EndPortalFrameHelper.hasEyeOfEnder(frontBlockState)
        || (!stack.method_7960() && stack.method_7909() != class_1802.field_8449)) {
      this.method_27955(false);
      return stack;
    }

    class_1799 newStack = this.addEyeOfEnderToInventory(stack, pointer);
    if (newStack != null) {
      EndPortalFrameHelper.setEmptyEndPortalFrameState(world, frontBlockState, frontBlockPos);
      return newStack;
    }

    this.method_27955(false);
    return stack;
  }

  private class_1799 addEyeOfEnderToInventory(class_1799 originalStack,
                                             class_2342 blockPointer) {
    class_1792 itemToAdd = class_1802.field_8449;
    class_1799 newStack = addItemToStack(originalStack, itemToAdd);
    if (newStack != null) {
      return newStack;
    }

    class_2601 dispenserBlockEntity = BlockPointerHelper.getDispenserBlockEntity(blockPointer);
    return addToFirstAvailableSlot(dispenserBlockEntity, itemToAdd)
           ? originalStack
           : null;
  }

  private class_1799 addItemToStack(class_1799 itemStack, class_1792 itemToAdd) {
    if (itemStack.method_7960()) {
      return new class_1799(itemToAdd);
    }

    int combinedCount = itemStack.method_7947() + 1;
    if (itemStack.method_7909() != itemToAdd || combinedCount > itemStack.method_7914()) {
      return null;
    }

    return new class_1799(itemToAdd, combinedCount);
  }

  private boolean addToFirstAvailableSlot(class_2601 dispenserBlockEntity, class_1792 itemToAdd) {
    for (int slot = 0; slot < class_2601.field_31340; slot++) {
      class_1799 currentSlotStack = dispenserBlockEntity.method_5438(slot);
      class_1799 newStack = addItemToStack(currentSlotStack, itemToAdd);
      if (newStack != null) {
        dispenserBlockEntity.method_5447(slot, newStack);
        return true;
      }
    }

    return false;
  }
}
