package carpetaddonsnotfound.phantomspawning;

import carpetaddonsnotfound.CarpetAddonsNotFoundSettings;
import net.minecraft.class_1657;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_3218;

/**
 * The phantom spawning handler for the
 * {@link carpetaddonsnotfound.CarpetAddonsNotFoundSettings#disablePhantomSpawningInMushroomFields} rule.
 *
 * @author Gilly7CE
 * @see PhantomSpawningHandler
 */
public final class DisableInMushroomFieldsHandler implements PhantomSpawningHandler {
  private PhantomSpawningHandler nextHandler = new DefaultHandler();

  /**
   * {@inheritDoc}
   */
  @Override
  public PhantomSpawningHandler setNextHandler(PhantomSpawningHandler nextHandler) {
    this.nextHandler = nextHandler;
    return this.nextHandler;
  }

  /**
   * Determines whether a phantom can spawn around the player
   *
   * @param playerEntity
   *         the player entity to conditionally spawn the phantom around
   * @param world
   *         the current minecraft world.
   *
   * @return false if the player entity is in a mushroom fields biome and
   * {@link carpetaddonsnotfound.CarpetAddonsNotFoundSettings#disablePhantomSpawningInMushroomFields} rule is enabled,
   * otherwise it is passed to next handler which could return true or false.
   */
  @Override
  public boolean canSpawnPhantom(class_1657 playerEntity, class_3218 world) {
    if (CarpetAddonsNotFoundSettings.disablePhantomSpawningInMushroomFields &&
        playerIsWithinTheMushroomFieldsBiome(playerEntity, world)) {
      return false;
    }

    return this.nextHandler.canSpawnPhantom(playerEntity, world);
  }

  private boolean playerIsWithinTheMushroomFieldsBiome(class_1657 playerEntity, class_3218 world) {
    class_2338 pos = playerEntity.method_24515();
    //#if MC>11701
    //$$ RegistryEntry<Biome> registryEntry = world.getBiome(pos);
    //$$ RegistryKey<Biome> biomePlayerIsIn = registryEntry.getKey().orElse(null);
    //$$ return biomePlayerIsIn == BiomeKeys.MUSHROOM_FIELDS;
    //#else
    class_1959 biome = world.method_23753(pos);
    return biome.method_8688() == class_1959.class_1961.field_9365;
    //#endif
  }
}
