package carpetaddonsnotfound.mixins;

import carpetaddonsnotfound.phantomspawning.PhantomSpawningHandler;
import carpetaddonsnotfound.phantomspawning.PhantomSpawningHandlerHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2910;
import net.minecraft.class_3218;

@Mixin(class_2910.class)
public abstract class PhantomSpawnerMixin {
  /**
   * Modifies the list of {@link class_1657}'s which are looped through when attempting to spawn phantoms. The
   * returned list will be the ones which this mod determines can have phantoms spawn around.
   *
   * @param instance
   *         the current {@link class_3218}
   *
   * @return the list of {@link class_1657}'s which can have phantoms spawn around, according to the mod anyway!
   */
  @Redirect(method = "spawn",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/server/world/ServerWorld;getPlayers()Ljava/util/List;"))
  private List<class_1657> getPlayersThatPhantomsCanSpawnAround(class_3218 instance) {
    List<class_1657> newList = new ArrayList<>();
    for (class_1657 playerEntity : instance.method_18456()) {
      PhantomSpawningHandler phantomSpawningHandler = PhantomSpawningHandlerHelper.getPhantomSpawningHandler();
      if (phantomSpawningHandler.canSpawnPhantom(playerEntity, instance)) {
        newList.add(playerEntity);
      }
    }

    return newList;
  }
}
