package carpetaddonsnotfound.mixins;

import carpetaddonsnotfound.dispenser.CarpetAddonsNotFoundDispenserBehaviors;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.class_1799;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2357;
import net.minecraft.class_2601;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_2315.class)
public abstract class DispenserBlock_GetCustomBehaviorMixin {
  /**
   * Gets the custom dispenser behavior for a non-empty item stack
   *
   * @param serverWorld
   *         the server world
   * @param pos
   *         the block position
   * @param ci
   *         the callback information
   * @param blockPointer
   *         the block pointer
   * @param dispenserBlockEntity
   *         the dispenser block entity
   * @param i
   *         the non-empty dispenser slot number
   * @param itemStack
   *         the item stack
   */
  @Inject(
          method = "dispense",
          at = @At(
                  value = "INVOKE",
                  //#if MC>12004
                  target = "Lnet/minecraft/block/DispenserBlock;getBehaviorForItem(Lnet/minecraft/world/World;" +
                           "Lnet/minecraft/item/ItemStack;)Lnet/minecraft/block/dispenser/DispenserBehavior;"
                  //#else
                  //$$ target = "Lnet/minecraft/block/DispenserBlock;getBehaviorForItem(Lnet/minecraft/item/ItemStack;)" +
                  //$$          "Lnet/minecraft/block/dispenser/DispenserBehavior;"
                  //#endif
          ),
          cancellable = true
  )
  private void dispenseCustomBehaviorNonEmptyItemStack(class_3218 serverWorld,
                                                       //#if MC>11904
                                                       class_2680 state,
                                                       //#endif
                                                       class_2338 pos,
                                                       CallbackInfo ci,
                                                       @Local class_2601 dispenserBlockEntity,
                                                       //#if MC>11904
                                                       @Local class_2342 blockPointer,
                                                       //#else
                                                       //$$ @Local BlockPointerImpl blockPointer,
                                                       //#endif
                                                       @Local int i,
                                                       @Local class_1799 itemStack) {
    class_2357 customBehavior =
            CarpetAddonsNotFoundDispenserBehaviors.getCustomDispenserBehavior(
                    serverWorld,
                    pos,
                    blockPointer,
                    itemStack);

    if (customBehavior == null) {
      return;
    }

    class_1799 resultStack = customBehavior.dispense(blockPointer, itemStack);
    dispenserBlockEntity.method_5447(i, resultStack);
    ci.cancel();
  }

  /**
   * Gets the custom dispenser behavior for an empty item stack. It is injected before the empty dispenser fail event is
   * invoked in the dispense method, and if there is a valid behavior will prevent the failure event being raised.
   *
   * @param serverWorld
   *         the server world
   * @param pos
   *         the block position
   * @param ci
   *         the callback info
   * @param blockPointer
   *         the block pointer
   * @param dispenserBlockEntity
   *         the dispenser block entity
   */
  @Inject(
          method = "dispense",
          at = @At(
                  value = "INVOKE",
                  target = "Lnet/minecraft/server/world/ServerWorld;syncWorldEvent" +
                           "(ILnet/minecraft/util/math/BlockPos;I)V"
          ),
          cancellable = true
  )
  private void dispenseCustomBehaviorEmptyItemStack(class_3218 serverWorld,
                                                    //#if MC>11904
                                                    class_2680 state,
                                                    //#endif
                                                    class_2338 pos,
                                                    CallbackInfo ci,
                                                    @Local class_2601 dispenserBlockEntity,
                                                    //#if MC>11904
                                                    @Local class_2342 blockPointer
                                                    //#else
                                                    //$$ @Local BlockPointerImpl blockPointer
                                                    //#endif
                                                   ) {
    class_1799 itemStack = class_1799.field_8037;
    class_2357 customBehavior =
            CarpetAddonsNotFoundDispenserBehaviors.getCustomDispenserBehavior(
                    serverWorld,
                    pos,
                    blockPointer,
                    itemStack);

    if (customBehavior == null) {
      return;
    }

    // Assign a random empty slot the result ItemStack
    int slot;
    //#if MC>11802
    slot = serverWorld.field_9229.method_39332(0, dispenserBlockEntity.method_5439() - 1);
    //#else
    //$$ slot = serverWorld.random.nextInt(0, dispenserBlockEntity.size());
    //#endif
    class_1799 resultStack = customBehavior.dispense(blockPointer, itemStack);
    dispenserBlockEntity.method_5447(slot, resultStack);
    ci.cancel();
  }
}
