package carpetaddonsnotfound.instantmining;

import net.minecraft.class_1792;
import net.minecraft.class_2680;

public class CompositeInstantMiningRatioCalculator implements InstantMiningRatioCalculator {

  private final ToolInstantMiningRatioCalculator[] calculators;

  public CompositeInstantMiningRatioCalculator() {
    this.calculators = ToolInstantMiningRatioCalculator.values();
  }

  @Override
  public float getInstantMiningRatio(class_2680 blockState, class_1792 mainHand) {
    for (ToolInstantMiningRatioCalculator calculator : calculators) {
      if (!calculator.canInstantMine(blockState, mainHand)) {
        continue;
      }

      return calculator.getInstantMiningRatio(blockState, mainHand);
    }

    return 1.0f;
  }
}
