package carpetaddonsnotfound.instantmining;

import carpetaddonsnotfound.lists.BlockList;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.item.*;

import java.util.HashSet;

public enum ToolInstantMiningRatioCalculator implements InstantMiningRatioCalculator {
  NetheriteAxeWood(
          InstantMiningCarpetRuleKeys.netheriteAxeWood,
          class_1802.field_22025,
          2,
          class_1802.field_8825,
          3,
          new HashSet<>(BlockList.wood)),
  NetheritePickaxeBlueIce(
          InstantMiningCarpetRuleKeys.netheritePickaxeBlueIce,
          class_1802.field_22024,
          2,
          class_1802.field_22024,
          7,
          new HashSet<>(BlockList.blueIce)),
  NetheritePickaxeCobbledDeepslate(
          InstantMiningCarpetRuleKeys.netheritePickaxeDeepslate,
          class_1802.field_22024,
          2,
          class_1802.field_22024,
          10,
          new HashSet<>(BlockList.cobbledDeepslate)),
  NetheritePickaxeCobblestone(
          InstantMiningCarpetRuleKeys.netheritePickaxeCobblestone,
          class_1802.field_22024,
          2,
          class_1802.field_8335,
          3,
          new HashSet<>(BlockList.cobblestone)),
  NetheritePickaxeDeepslate(
          InstantMiningCarpetRuleKeys.netheritePickaxeDeepslate,
          class_1802.field_22024,
          2,
          class_1802.field_22024,
          8,
          new HashSet<>(BlockList.deepslate)),
  NetheritePickaxeEndStone(
          InstantMiningCarpetRuleKeys.netheritePickaxeEndStone,
          class_1802.field_22024,
          2,
          class_1802.field_22024,
          8,
          new HashSet<>(BlockList.endStone)),
  NetheritePickaxeNetherBricks(
          InstantMiningCarpetRuleKeys.netheritePickaxeNetherBricks,
          class_1802.field_22024,
          2,
          class_1802.field_8335,
          3,
          new HashSet<>(BlockList.netherBricks));

  private final String carpetRuleKey;
  private final int originalHasteLevel;
  private final int newHasteLevel;
  private final class_1792 originalTool;
  private final class_1792 newTool;
  private final HashSet<class_2248> blocksThatCanBeInstantMined;

  ToolInstantMiningRatioCalculator(
          String carpetRuleKey,
          class_1792 originalTool,
          int originalHasteLevel,
          class_1792 newTool,
          int newHasteLevel,
          HashSet<class_2248> blocksThatCanBeInstantMined
                                  ) {

    this.carpetRuleKey = carpetRuleKey;
    this.originalHasteLevel = originalHasteLevel;
    this.newHasteLevel = newHasteLevel;
    this.originalTool = originalTool;
    this.newTool = newTool;
    this.blocksThatCanBeInstantMined = blocksThatCanBeInstantMined;
  }

  @Override
  public float getInstantMiningRatio(class_2680 blockState, class_1792 mainHand) {
    return HasteInstantMiningRatioCalculator.getRatio(
            blockState,
            this.originalHasteLevel,
            this.originalTool,
            this.newHasteLevel,
            this.newTool);
  }

  public boolean canInstantMine(class_2680 blockState, class_1792 item) {
    return InstantMiningCarpetRuleAccessor.carpetRules.get(carpetRuleKey).get() &&
           item == this.originalTool &&
           this.blocksThatCanBeInstantMined.contains(blockState.method_26204());
  }
}
