package carpetaddonsnotfound.mixins;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

import static carpetaddonsnotfound.CarpetAddonsNotFoundSettings.stonecuttersDoDamage;

import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3718;
import net.minecraft.class_4970;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.minecraft.class_8111;

@Mixin(class_3718.class)
public abstract class StonecutterBlock_StonecuttersDoDamageMixin extends class_2248 {
  StonecutterBlock_StonecuttersDoDamageMixin(class_4970.class_2251 settings) {
    super(settings);
  }

  @Override
  public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
    if (world.method_8608() || !world.method_49803(pos) || !stonecuttersCanDealDamage()) {
      return;
    }

    if (stonecuttersCanHeal() && entity instanceof class_1309 livingEntity) {
      livingEntity.method_6025(-stonecuttersDoDamage);
      return;
    }

    //#if MC>11802
    class_6880<class_8110> type = getDamageTypeRegistryEntry(world);
    //#if MC>12101
    if (!(world instanceof class_3218 serverWorld)) {
      return;
    }
    //#endif

    entity.method_64397(
            //#if MC>12101
            serverWorld,
            //#endif
            new class_1282(type, new class_243(pos.method_10263(), pos.method_10264(), pos.method_10260())),
            stonecuttersDoDamage);
    //#else
    //$$ entity.damage(DamageSource.GENERIC, stonecuttersDoDamage);
    //#endif
  }

  @Unique
  private boolean stonecuttersCanDealDamage() {
    //#if MC>11802
    return stonecuttersDoDamage != 0.0f;
    //#else
    //$$ return stonecuttersDoDamage != 0;
    //#endif
  }

  @Unique
  private boolean stonecuttersCanHeal() {
    //#if MC>11802
    return stonecuttersDoDamage < 0.0f;
    //#else
    //$$ return stonecuttersDoDamage < 0;
    //#endif
  }

  //#if MC>11802
  @Unique
  private class_6880<class_8110> getDamageTypeRegistryEntry(class_1937 world) {
    class_5455 registryManager = world.method_30349();
    //#if MC>12101
    class_2378<class_8110> damageTypeRegistry = registryManager.method_30530(class_7924.field_42534);
    return damageTypeRegistry.method_47983(damageTypeRegistry.method_29107(class_8111.field_42348));
    //#else
    //$$ return registryManager.get(RegistryKeys.DAMAGE_TYPE).getEntry(DamageTypes.GENERIC).orElseThrow();
    //#endif
  }
  //#endif
}
