#version 130

#define GBUFFERS_CLOUDS

varying vec2 texcoord;
varying vec4 color;
uniform sampler2D texture;

#ifdef Fog
const int GL_LINEAR = 9729;
const int GL_EXP = 2048;
uniform int fogMode;
uniform int isEyeInWater;
#endif

#ifdef DISTANT_HORIZONS
uniform float viewHeight;
uniform float viewWidth;
uniform sampler2D dhDepthTex1;
#endif

void main() {

#ifdef DISTANT_HORIZONS
    if(texture2D(dhDepthTex1, gl_FragCoord.xy / vec2(viewWidth, viewHeight)).x < 1.0) discard;
#endif

	gl_FragData[0] = texture2D(texture, texcoord.xy)*color;
	gl_FragData[1] = vec4(0.0); //fill normal buffer with 0.0, improves performance

#ifdef Fog
	if (fogMode == GL_EXP) gl_FragData[0].rgb = mix(gl_FragData[0].rgb, gl_Fog.color.rgb, 1.0 - clamp(exp(-gl_Fog.density * gl_FogFragCoord), 0.0, 1.0));
	else if (fogMode == GL_LINEAR || isEyeInWater == 1.0 || isEyeInWater == 2.0 || isEyeInWater == 3.0) gl_FragData[0].rgb = mix(gl_FragData[0].rgb, gl_Fog.color.rgb, clamp((gl_FogFragCoord - gl_Fog.start) * gl_Fog.scale, 0.0, 1.0));
#endif	
}

