/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.warp_pipes.event_handlers;

import com.wenxin2.warp_pipes.blocks.client.WarpPipeScreen;
import com.wenxin2.warp_pipes.blocks.entities.BaseWarpBlockEntity;
import com.wenxin2.warp_pipes.blocks.entities.WarpPipeBlockEntity;
import com.wenxin2.warp_pipes.registries.ConfigRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="warp_pipes")
public class WarpPipesEventHandlers {
    @SubscribeEvent
    public static void onPlayerRightClick(PlayerInteractEvent.RightClickBlock event) {
        BaseWarpBlockEntity warpBE;
        BlockEntity blockEntity;
        Level world = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = world.getBlockState(pos);
        ItemStack heldItem = event.getItemStack();
        Player player = event.getEntity();
        if (world.isClientSide()) {
            BlockPos clickedPos = event.getPos();
            BlockEntity blockEntity2 = event.getLevel().getBlockEntity(clickedPos);
            if (blockEntity2 instanceof WarpPipeBlockEntity) {
                WarpPipeScreen.lastClickedPos = clickedPos;
            }
        }
        if (heldItem.getItem() instanceof HoneycombItem && (blockEntity = world.getBlockEntity(pos)) instanceof BaseWarpBlockEntity) {
            warpBE = (BaseWarpBlockEntity)blockEntity;
            if ((((Boolean)ConfigRegistry.WAX_DISABLES_BUBBLES.get()).booleanValue() || ((Boolean)ConfigRegistry.WAX_DISABLES_CLOSING.get()).booleanValue() || ((Boolean)ConfigRegistry.WAX_DISABLES_RENAMING.get()).booleanValue() || ((Boolean)ConfigRegistry.WAX_DISABLES_WATER_SPOUTS.get()).booleanValue() || ((Boolean)ConfigRegistry.WAX_DISABLES_WARP_LINKING.get()).booleanValue()) && !warpBE.isWaxed()) {
                warpBE.setWaxed(true);
                warpBE.markUpdated();
                heldItem.consume(1, (LivingEntity)player);
                ParticleUtils.spawnParticlesOnBlockFaces((Level)world, (BlockPos)pos, (ParticleOptions)ParticleTypes.WAX_ON, (IntProvider)UniformInt.of((int)3, (int)5));
                world.playSound(player, pos, SoundEvents.HONEYCOMB_WAX_ON, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                world.sendBlockUpdated(pos, state, state, 3);
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
        if (heldItem.getItem() instanceof AxeItem && (blockEntity = world.getBlockEntity(pos)) instanceof BaseWarpBlockEntity) {
            warpBE = (BaseWarpBlockEntity)blockEntity;
            if (((Boolean)ConfigRegistry.ALLOW_PIPE_UNWAXING.get()).booleanValue() && warpBE.isWaxed()) {
                warpBE.setWaxed(false);
                warpBE.markUpdated();
                heldItem.hurtAndBreak(1, (LivingEntity)player, Player.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                ParticleUtils.spawnParticlesOnBlockFaces((Level)world, (BlockPos)pos, (ParticleOptions)ParticleTypes.WAX_OFF, (IntProvider)UniformInt.of((int)3, (int)5));
                world.playSound(null, pos, SoundEvents.AXE_WAX_OFF, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                world.sendBlockUpdated(pos, state, state, 3);
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
    }
}

