/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.warp_pipes.integration;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class CompatRegistry {
    public static final Supplier<Block> COIN = CompatRegistry.make("marioverse:coin", BuiltInRegistries.BLOCK);
    public static final Supplier<Block> STAR_COIN = CompatRegistry.make("marioverse:star_coin", BuiltInRegistries.BLOCK);
    public static final Supplier<Item> ANTIQUE_INK = CompatRegistry.make("supplementaries:antique_ink", BuiltInRegistries.ITEM);
    public static final Supplier<Item> BOMB_BLUE_ITEM = CompatRegistry.make("supplementaries:bomb_blue", BuiltInRegistries.ITEM);
    public static final Supplier<Item> BOMB_ITEM = CompatRegistry.make("supplementaries:bomb", BuiltInRegistries.ITEM);
    public static final Supplier<Item> BOMB_SPIKY_ITEM = CompatRegistry.make("supplementaries:bomb_spiky", BuiltInRegistries.ITEM);
    public static final Supplier<Item> BUBBLE_BLOWER = CompatRegistry.make("supplementaries:bubble_blower", BuiltInRegistries.ITEM);
    public static final Supplier<Item> CANNONBALL_ITEM = CompatRegistry.make("supplementaries:cannonball", BuiltInRegistries.ITEM);
    public static final Supplier<Item> CONFETTI_POPPER_ITEM = CompatRegistry.make("supplementaries:confetti_popper", BuiltInRegistries.ITEM);
    public static final Supplier<Item> DASH_MUSHROOM = CompatRegistry.make("supplementaries:dash_mushroom", BuiltInRegistries.ITEM);
    public static final Supplier<Item> HAT_STAND_ITEM = CompatRegistry.make("supplementaries:hat_stand", BuiltInRegistries.ITEM);
    public static final Supplier<Item> ICE_BOMB_ITEM = CompatRegistry.make("twilightforest:ice_bomb", BuiltInRegistries.ITEM);
    public static final Supplier<Item> SOAP = CompatRegistry.make("supplementaries:soap", BuiltInRegistries.ITEM);
    public static final Supplier<EntityType<?>> TEST_DUMMY = CompatRegistry.make("dummmmmmy:test_dummy", BuiltInRegistries.ENTITY_TYPE);
    public static final Supplier<EntityType<?>> BOMB = CompatRegistry.make("supplementaries:bomb", BuiltInRegistries.ENTITY_TYPE);
    public static final Supplier<EntityType<?>> CANNONBALL = CompatRegistry.make("supplementaries:cannonball", BuiltInRegistries.ENTITY_TYPE);
    public static final Supplier<EntityType<?>> HAT_STAND = CompatRegistry.make("supplementaries:hat_stand", BuiltInRegistries.ENTITY_TYPE);
    public static final Supplier<EntityType<?>> ICE_BOMB = CompatRegistry.make("twilightforest:thrown_ice", BuiltInRegistries.ENTITY_TYPE);
    public static final Supplier<SoundEvent> BOMB_SOUND = CompatRegistry.make("supplementaries:item.bomb", BuiltInRegistries.SOUND_EVENT);
    public static final Supplier<SoundEvent> BUBBLE_BLOWER_SOUND = CompatRegistry.make("supplementaries:item.bubble_blower", BuiltInRegistries.SOUND_EVENT);
    public static final Supplier<SoundEvent> CANNON_SOUND = CompatRegistry.make("supplementaries:block.cannon.fire", BuiltInRegistries.SOUND_EVENT);
    public static final Supplier<SoundEvent> COIN_PICKUP_SOUND = CompatRegistry.make("marioverse:block.coin_pickup", BuiltInRegistries.SOUND_EVENT);
    public static final Supplier<SoundEvent> CONFETTI_POPPER_SOUND = CompatRegistry.make("supplementaries:item.confetti_popper", BuiltInRegistries.SOUND_EVENT);
    public static final Supplier<SoundEvent> ICE_BOMB_SOUND = CompatRegistry.make("twilightforest:item.twilightforest.ice_bomb.fired", BuiltInRegistries.SOUND_EVENT);
    public static final Supplier<SoundEvent> ITEM_SPAWNS = CompatRegistry.make("marioverse:block.item_spawns", BuiltInRegistries.SOUND_EVENT);
    public static final Supplier<SoundEvent> MOB_SPAWNS = CompatRegistry.make("marioverse:block.mob_spawns", BuiltInRegistries.SOUND_EVENT);
    public static final Supplier<SoundEvent> POWER_UP_SPAWNS = CompatRegistry.make("marioverse:block.power_up_spawns", BuiltInRegistries.SOUND_EVENT);
    public static final Supplier<SoundEvent> STAR_COIN_PICKUP_SOUND = CompatRegistry.make("marioverse:block.star_coin_pickup", BuiltInRegistries.SOUND_EVENT);
    public static final Supplier<ParticleType<?>> SUDS_PARTICLE = CompatRegistry.make("supplementaries:suds", BuiltInRegistries.PARTICLE_TYPE);

    private static <T> Supplier<@Nullable T> make(String name, Registry<T> registry) {
        return Suppliers.memoize(() -> registry.getOptional(ResourceLocation.parse((String)name)).orElse(null));
    }
}

