/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.warp_pipes.utils;

import com.wenxin2.warp_pipes.blocks.WarpPipeBlock;
import com.wenxin2.warp_pipes.blocks.entities.BaseWarpBlockEntity;
import com.wenxin2.warp_pipes.blocks.entities.WarpPipeBlockEntity;
import com.wenxin2.warp_pipes.registries.ConfigRegistry;
import com.wenxin2.warp_pipes.registries.SoundRegistry;
import com.wenxin2.warp_pipes.registries.TagRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public interface BlockWarpEntitiesHandler {
    public boolean wp$getBlockWarpTeleportConfig();

    private static boolean getShiftKeyForEntity(Entity entity) {
        return !entity.isShiftKeyDown() && !(entity instanceof Player) || entity.isShiftKeyDown() && entity instanceof Player;
    }

    public boolean wp$doPreventWarp();

    public void wp$setPreventWarp(boolean var1);

    public int wp$getPreventWarpCooldown();

    public void wp$setPreventWarpCooldown(int var1);

    public int wp$getWarpCooldown();

    public void wp$setWarpCooldown(int var1);

    default public void enterWarp(Entity entity, Level world, BlockPos pos) {
        int entityId;
        BlockPos warpPos;
        BaseWarpBlockEntity warpBE;
        BlockState state = world.getBlockState(pos);
        BlockState stateAboveEntity = world.getBlockState(pos.above(Math.round(entity.getBbHeight())));
        BlockEntity blockEntity = world.getBlockEntity(pos);
        BlockEntity blockEntityAbove = world.getBlockEntity(pos.above(Math.round(entity.getBbHeight())));
        if (blockEntity instanceof BaseWarpBlockEntity && (warpBE = (BaseWarpBlockEntity)blockEntity).getLevel() != null) {
            warpPos = warpBE.destinationPos;
            entityId = entity.getId();
            if (BaseWarpBlockEntity.WARPED_ENTITIES.getOrDefault(entityId, true).booleanValue()) {
                BaseWarpBlockEntity.WARPED_ENTITIES.put(entityId, false);
            }
            if (state.getBlock() instanceof WarpPipeBlock) {
                this.enterWarpPipe(entity, world, pos, warpPos, warpBE);
            }
        }
        if (blockEntityAbove instanceof BaseWarpBlockEntity && (warpBE = (BaseWarpBlockEntity)blockEntityAbove).getLevel() != null) {
            warpPos = warpBE.destinationPos;
            entityId = entity.getId();
            if (BaseWarpBlockEntity.WARPED_ENTITIES.getOrDefault(entityId, true).booleanValue()) {
                BaseWarpBlockEntity.WARPED_ENTITIES.put(entityId, false);
            }
            if (stateAboveEntity.getBlock() instanceof WarpPipeBlock) {
                this.enterWarpPipeAbove(entity, world, pos, warpPos, warpBE);
            }
        }
    }

    default public void enterWarpPipe(Entity entity, Level world, BlockPos pos, BlockPos warpPos, BaseWarpBlockEntity warpBE) {
        block54: {
            Player player;
            int blockZ;
            int blockY;
            int blockX;
            double entityZ;
            double entityY;
            double entityX;
            BlockState state;
            block62: {
                Player player2;
                LivingEntity livingEntity;
                block60: {
                    block61: {
                        block58: {
                            block59: {
                                block56: {
                                    block57: {
                                        block55: {
                                            state = world.getBlockState(pos);
                                            entityX = entity.getX();
                                            entityY = entity.getY();
                                            entityZ = entity.getZ();
                                            blockX = pos.getX();
                                            blockY = pos.getY();
                                            blockZ = pos.getZ();
                                            if (this.wp$doPreventWarp() || !this.wp$getBlockWarpTeleportConfig() || entity.getType().is(TagRegistry.CANNOT_WARP)) break block54;
                                            if (state.getValue((Property)WarpPipeBlock.FACING) != Direction.UP || !BlockWarpEntitiesHandler.getShiftKeyForEntity(entity) || !(entityY + (double)entity.getBbHeight() >= (double)(blockY - 1)) || !(entityX < (double)(blockX + 1)) || !(entityX > (double)blockX) || !(entityZ < (double)(blockZ + 1)) || !(entityZ > (double)blockZ)) break block55;
                                            if (!warpBE.preventWarp && this.wp$getWarpCooldown() == 0) {
                                                this.warp(entity, world, pos, state, warpPos, warpBE);
                                            } else if (entity instanceof Player) {
                                                player = (Player)entity;
                                                if (warpBE.preventWarp) {
                                                    this.displayWarpDisruptedMessage(player, state);
                                                } else if (warpBE.hasDestinationPos()) {
                                                    this.displayCooldownMessage(player);
                                                }
                                            }
                                            break block56;
                                        }
                                        if (state.getValue((Property)WarpPipeBlock.FACING) != Direction.NORTH || entity.isShiftKeyDown()) break block56;
                                        if (entity.onGround() || entity.isInWaterOrBubble() || entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).isFallFlying()) break block57;
                                        if (!(entity instanceof Player)) break block56;
                                        player2 = (Player)entity;
                                        if (!player2.getAbilities().flying) break block56;
                                    }
                                    if (entityX < (double)(blockX + 1) && entityX > (double)blockX && entityY >= (double)blockY && entityY < (double)blockY + 0.75 && entityZ < (double)blockZ) {
                                        if (!warpBE.preventWarp && this.wp$getWarpCooldown() == 0) {
                                            this.warp(entity, world, pos, state, warpPos, warpBE);
                                        } else if (entity instanceof Player) {
                                            player = (Player)entity;
                                            if (warpBE.preventWarp) {
                                                this.displayWarpDisruptedMessage(player, state);
                                            } else if (warpBE.hasDestinationPos()) {
                                                this.displayCooldownMessage(player);
                                            }
                                        }
                                    }
                                }
                                if (state.getValue((Property)WarpPipeBlock.FACING) != Direction.SOUTH || entity.isShiftKeyDown()) break block58;
                                if (entity.onGround() || entity.isInWaterOrBubble() || entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).isFallFlying()) break block59;
                                if (!(entity instanceof Player)) break block58;
                                player2 = (Player)entity;
                                if (!player2.getAbilities().flying) break block58;
                            }
                            if (entityX < (double)(blockX + 1) && entityX > (double)blockX && entityY >= (double)blockY && entityY < (double)blockY + 0.75 && entityZ > (double)blockZ + 0.25) {
                                if (!warpBE.preventWarp && this.wp$getWarpCooldown() == 0) {
                                    this.warp(entity, world, pos, state, warpPos, warpBE);
                                } else if (entity instanceof Player) {
                                    player = (Player)entity;
                                    if (warpBE.preventWarp) {
                                        this.displayWarpDisruptedMessage(player, state);
                                    } else if (warpBE.hasDestinationPos()) {
                                        this.displayCooldownMessage(player);
                                    }
                                }
                            }
                        }
                        if (state.getValue((Property)WarpPipeBlock.FACING) != Direction.EAST || entity.isShiftKeyDown()) break block60;
                        if (entity.onGround() || entity.isInWaterOrBubble() || entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).isFallFlying()) break block61;
                        if (!(entity instanceof Player)) break block60;
                        player2 = (Player)entity;
                        if (!player2.getAbilities().flying) break block60;
                    }
                    if (entityX > (double)blockX && entityY >= (double)blockY && entityY < (double)blockY + 0.75 && entityZ < (double)(blockZ + 1) && entityZ > (double)blockZ) {
                        if (!warpBE.preventWarp && this.wp$getWarpCooldown() == 0) {
                            this.warp(entity, world, pos, state, warpPos, warpBE);
                        } else if (entity instanceof Player) {
                            player = (Player)entity;
                            if (warpBE.preventWarp) {
                                this.displayWarpDisruptedMessage(player, state);
                            } else if (warpBE.hasDestinationPos()) {
                                this.displayCooldownMessage(player);
                            }
                        }
                    }
                }
                if (state.getValue((Property)WarpPipeBlock.FACING) != Direction.WEST || entity.isShiftKeyDown()) break block54;
                if (entity.onGround() || entity.isInWaterOrBubble() || entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).isFallFlying()) break block62;
                if (!(entity instanceof Player)) break block54;
                player2 = (Player)entity;
                if (!player2.getAbilities().flying) break block54;
            }
            if (entityX < (double)blockX && entityY >= (double)blockY && entityY < (double)blockY + 0.75 && entityZ < (double)(blockZ + 1) && entityZ > (double)blockZ) {
                if (!warpBE.preventWarp && this.wp$getWarpCooldown() == 0) {
                    this.warp(entity, world, pos, state, warpPos, warpBE);
                } else if (entity instanceof Player) {
                    player = (Player)entity;
                    if (warpBE.preventWarp) {
                        this.displayWarpDisruptedMessage(player, state);
                    } else if (warpBE.hasDestinationPos()) {
                        this.displayCooldownMessage(player);
                    }
                }
            }
        }
    }

    default public void enterWarpPipeAbove(Entity entity, Level world, BlockPos pos, BlockPos warpPos, BaseWarpBlockEntity warpBE) {
        BlockState stateAboveEntity = world.getBlockState(pos.above(Math.round(entity.getBbHeight())));
        double entityX = entity.getX();
        double entityZ = entity.getZ();
        int blockX = pos.getX();
        int blockZ = pos.getZ();
        if (!this.wp$doPreventWarp() && this.wp$getBlockWarpTeleportConfig() && !entity.getType().is(TagRegistry.CANNOT_WARP) && stateAboveEntity.getValue((Property)WarpPipeBlock.FACING) == Direction.DOWN && entityX < (double)(blockX + 1) && entityX > (double)blockX && entityZ < (double)(blockZ + 1) && entityZ > (double)blockZ) {
            if (!warpBE.preventWarp && this.wp$getWarpCooldown() == 0) {
                this.warp(entity, world, pos, stateAboveEntity, warpPos, warpBE);
            } else if (entity instanceof Player) {
                Player player = (Player)entity;
                if (warpBE.preventWarp) {
                    this.displayWarpDisruptedMessage(player, stateAboveEntity);
                } else if (warpBE.hasDestinationPos()) {
                    this.displayCooldownMessage(player);
                }
            }
        }
    }

    default public void warp(Entity entity, Level world, BlockPos pos, BlockState state, BlockPos warpPos, BaseWarpBlockEntity warpBE) {
        if (warpPos != null && !(world.getBlockEntity(warpPos) instanceof BaseWarpBlockEntity) && entity instanceof Player) {
            Player player = (Player)entity;
            this.displayDestinationMissingMessage(player);
        }
        if (warpPos != null && world.getBlockEntity(warpPos) instanceof BaseWarpBlockEntity) {
            warpState = world.getBlockState(warpPos);
            if (warpState.getBlock() instanceof WarpPipeBlock) {
                WarpPipeBlockEntity.warp(entity, warpPos, world, warpState);
            }
            if (state.getBlock() instanceof WarpPipeBlock) {
                world.playSound(null, pos, (SoundEvent)SoundRegistry.PIPE_WARPS.get(), SoundSource.BLOCKS);
            }
        } else if (warpBE.getUUID() != null && warpBE.getWarpUuid() != null && BaseWarpBlockEntity.findMatchingUUID(warpBE.getUUID()) != null) {
            warpPos = BaseWarpBlockEntity.findMatchingUUID(warpBE.getUUID());
            warpState = world.getBlockState(warpPos);
            if (warpState.getBlock() instanceof WarpPipeBlock) {
                WarpPipeBlockEntity.warp(entity, warpPos, world, warpState);
            }
            if (state.getBlock() instanceof WarpPipeBlock) {
                world.playSound(null, pos, (SoundEvent)SoundRegistry.PIPE_WARPS.get(), SoundSource.BLOCKS);
            }
            warpBE.setDestinationPos(warpPos);
            BlockEntity blockEntity = world.getBlockEntity(warpPos);
            if (blockEntity instanceof BaseWarpBlockEntity) {
                BaseWarpBlockEntity destBE = (BaseWarpBlockEntity)blockEntity;
                destBE.setDestinationPos(pos);
            }
        }
    }

    default public void displayCooldownMessage(Player player) {
        if (this.wp$getWarpCooldown() >= 10 && ((Boolean)ConfigRegistry.WARP_COOLDOWN_MESSAGE.get()).booleanValue()) {
            if (((Boolean)ConfigRegistry.WARP_COOLDOWN_MESSAGE_TICKS.get()).booleanValue()) {
                player.displayClientMessage((Component)Component.translatable((String)"display.warp_pipes.warp_pipe_cooldown.ticks", (Object[])new Object[]{this.wp$getWarpCooldown()}), true);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"display.warp_pipes.warp_pipe_cooldown"), true);
            }
        }
    }

    default public void displayWarpDisruptedMessage(Player player, BlockState state) {
        player.displayClientMessage((Component)Component.translatable((String)"display.warp_pipes.warp_disrupted", (Object[])new Object[]{state.getBlock().getName()}).withStyle(ChatFormatting.RED), true);
    }

    default public void displayDestinationMissingMessage(Player player) {
        player.displayClientMessage((Component)Component.translatable((String)"display.warp_pipes.warp_destination_missing"), true);
    }
}

